/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.xmlwriter.XMLWriter;

public final class HasFieldValueParameter
implements SearchParameter {
    private final String _field;
    private final Query _query;

    public HasFieldValueParameter(String name) {
        this._field = name;
        this._query = this.isEmpty() ? null : new FieldExistsQuery(this._field);
    }

    @Override
    public boolean isEmpty() {
        return this._field == null || this._field.isEmpty();
    }

    public String field() {
        return this._field;
    }

    @Override
    public Query toQuery() {
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("has-field-parameter", true);
        xml.attribute("is-empty", Boolean.toString(this.isEmpty()));
        xml.attribute("field", this._field);
        xml.closeElement();
    }

    public String toString() {
        return this._field;
    }
}

