/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.search.Facet;
import org.pageseeder.xmlwriter.XMLWriter;

public final class FacetParameter
implements SearchParameter {
    private final Facet _facet;
    private final String _value;
    private final Query _query;

    public FacetParameter(Facet facet, String value) {
        this._facet = facet;
        this._value = value;
        this._query = this._facet.forValue(value);
    }

    public Facet facet() {
        return this._facet;
    }

    public String value() {
        return this._value;
    }

    @Override
    public boolean isEmpty() {
        return this._query == null;
    }

    @Override
    public Query toQuery() {
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("selected-facet");
        xml.attribute("name", this._facet.name());
        xml.attribute("value", this._value);
        this._facet.toXML(xml);
        xml.closeElement();
    }
}

