/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.xmlwriter.XMLWriter;

public final class AnyTermParameter
implements SearchParameter {
    private static final AnyTermParameter EMPTY = new AnyTermParameter();
    private final List<Term> _terms;
    private volatile Query _query;

    private AnyTermParameter() {
        this._terms = Collections.emptyList();
    }

    public AnyTermParameter(String field, String text) throws NullPointerException {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        this._terms = Collections.singletonList(new Term(field, text));
    }

    public AnyTermParameter(List<Term> terms) throws NullPointerException {
        if (terms == null) {
            throw new NullPointerException("terms");
        }
        this._terms = terms;
    }

    @Override
    public boolean isEmpty() {
        return this._terms.isEmpty();
    }

    public List<Term> term() {
        return this._terms;
    }

    @Override
    public Query toQuery() {
        if (this.isEmpty()) {
            return null;
        }
        if (this._query == null) {
            this._query = this.buildQuery();
        }
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("any-term-parameter", true);
        xml.attribute("is-empty", Boolean.toString(this.isEmpty()));
        Terms.toXML(xml, this._terms);
        xml.closeElement();
    }

    public String toString() {
        return this._terms.toString();
    }

    public static AnyTermParameter empty() {
        return EMPTY;
    }

    private Query buildQuery() {
        if (this.isEmpty()) {
            return null;
        }
        if (this._terms.size() == 1) {
            return new TermQuery(this._terms.get(0));
        }
        BooleanQuery.Builder q = new BooleanQuery.Builder();
        for (Term t : this._terms) {
            q.add((Query)new TermQuery(t), BooleanClause.Occur.SHOULD);
        }
        return q.build();
    }
}

