/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.facet.FlexibleIntervalFacet;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class StringIntervalFacet
extends FlexibleIntervalFacet {
    private final int _intervalLength;
    private final boolean _caseSensitive;

    private StringIntervalFacet(String name, String start, String end, int maxIntervals, boolean caseSensitive, int length, boolean includeMin, boolean includeLastMax) {
        super(name, start, end, includeMin, includeLastMax, maxIntervals);
        this._intervalLength = length;
        this._caseSensitive = caseSensitive;
    }

    @Override
    protected Query termToQuery(Term t) {
        return new TermQuery(t);
    }

    @Override
    public String getType() {
        return "string-interval";
    }

    @Override
    protected FlexibleIntervalFacet.Interval findInterval(Term t) {
        if (t == null) {
            return null;
        }
        String maxTerm = this.end();
        String minTerm = this.end() == null ? null : this.start();
        String termValue = t.text();
        if (termValue.isEmpty()) {
            return null;
        }
        boolean forward = this.isAfter(termValue, this.start(), this.includeLower());
        String from = this.start();
        while (true) {
            boolean includeMax;
            String upper;
            String to = StringIntervalFacet.next(from, this._intervalLength, minTerm, maxTerm, forward);
            String lower = forward ? from : to;
            String string = upper = forward ? to : from;
            boolean bl = maxTerm != null && to.equals(StringIntervalFacet.next(to, this._intervalLength, minTerm, maxTerm, forward)) ? this.includeLastUpper() : (includeMax = !this.includeLower());
            if (maxTerm != null && (this.isAfter(lower, maxTerm, true) || this.isBefore(upper, minTerm, true))) {
                return null;
            }
            boolean lowerLimit = this.isAfter(termValue, lower, this.includeLower());
            boolean upperLimit = this.isBefore(termValue, upper, includeMax);
            if (lowerLimit && upperLimit) {
                return FlexibleIntervalFacet.Interval.stringInterval(lower, this.includeLower(), upper, includeMax);
            }
            if (forward && upperLimit) {
                return null;
            }
            if (!forward && lowerLimit) {
                return null;
            }
            if (from.equals(to)) {
                return null;
            }
            from = to;
        }
    }

    @Override
    protected void intervalToXML(FlexibleIntervalFacet.Interval interval, int cardinality, XMLWriter xml) throws IOException {
        xml.openElement("interval");
        if (interval.getMin() != null) {
            xml.attribute("min", interval.getMin());
        }
        if (interval.getMax() != null) {
            xml.attribute("max", interval.getMax());
        }
        if (interval.getMin() != null) {
            xml.attribute("include-min", interval.includeMin() ? "true" : "false");
        }
        if (interval.getMax() != null) {
            xml.attribute("include-max", interval.includeMax() ? "true" : "false");
        }
        xml.attribute("cardinality", cardinality);
        xml.closeElement();
    }

    private boolean isAfter(String s1, String s2, boolean includeEquals) {
        int comparison = this._caseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        return comparison > 0 || includeEquals && comparison == 0;
    }

    private boolean isBefore(String s1, String s2, boolean includeEquals) {
        int comparison = this._caseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        return comparison < 0 || includeEquals && comparison == 0;
    }

    private static String next(String s, int interval, String min, String max, boolean increase) {
        if (s.isEmpty()) {
            return s;
        }
        char nextFirstChar = (char)(s.charAt(0) + (increase ? 1 : -1) * interval);
        if (nextFirstChar < '0' && min != null) {
            return min;
        }
        if (nextFirstChar < '0') {
            nextFirstChar = '/';
        } else if (nextFirstChar > '9' && nextFirstChar < 'A') {
            nextFirstChar = increase ? (char)'A' : '9';
        } else if (nextFirstChar > 'Z' && nextFirstChar < 'a') {
            nextFirstChar = increase ? (char)'a' : 'Z';
        } else {
            if (nextFirstChar > 'z' && max != null) {
                return max;
            }
            if (nextFirstChar > 'z') {
                nextFirstChar = '{';
            } else {
                if (min != null && String.valueOf(nextFirstChar).compareTo(min) < 0) {
                    return min;
                }
                if (max != null && String.valueOf(nextFirstChar).compareTo(max) > 0) {
                    return max;
                }
            }
        }
        return nextFirstChar + s.substring(1);
    }

    public static class Builder {
        private int intervalLength = -1;
        private String start = null;
        private String end = null;
        private boolean includeMin = true;
        private boolean includeLastMax = true;
        private boolean caseSensitive = true;
        private String name = null;
        private int maxIntervals = -1;

        public Builder caseSensitive(boolean cs) {
            this.caseSensitive = cs;
            return this;
        }

        public Builder name(String n) {
            this.name = n;
            return this;
        }

        public Builder includeLastMax(boolean include) {
            this.includeLastMax = include;
            return this;
        }

        public Builder includeMin(boolean include) {
            this.includeMin = include;
            return this;
        }

        public Builder intervalLength(int length) {
            this.intervalLength = length;
            return this;
        }

        public Builder start(String thestart) {
            this.start = thestart;
            return this;
        }

        public Builder end(String theend) {
            this.end = theend;
            return this;
        }

        public Builder maxIntervals(int max) {
            this.maxIntervals = max;
            return this;
        }

        public StringIntervalFacet build() {
            if (this.name == null) {
                throw new IllegalStateException("Must have a field name");
            }
            if (this.start == null) {
                throw new IllegalStateException("Must have a start");
            }
            if (this.intervalLength <= 0) {
                throw new IllegalStateException("Must have a valid interval length");
            }
            return new StringIntervalFacet(this.name, this.start, this.end, this.maxIntervals, this.caseSensitive, this.intervalLength, this.includeMin, this.includeLastMax);
        }
    }
}

