/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.facet.FlexibleRangeFacet;
import org.pageseeder.flint.lucene.query.DateParameter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DateRangeFacet
extends FlexibleRangeFacet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateRangeFacet.class);
    private final DateTools.Resolution _resolution;
    private final List<OptimisedRange> _ranges = new ArrayList<OptimisedRange>();

    private DateRangeFacet(String name, DateTools.Resolution resolution, List<FlexibleRangeFacet.Range> ranges) {
        super(name);
        this._resolution = resolution;
        this._ranges.addAll(ranges.stream().map(x$0 -> new OptimisedRange((FlexibleRangeFacet.Range)x$0)).filter(r -> !r.invalid).collect(Collectors.toList()));
    }

    public DateTools.Resolution getResolution() {
        return this._resolution;
    }

    @Override
    protected Query termToQuery(Term t) {
        try {
            if (t.text().isEmpty()) {
                return new TermQuery(t);
            }
            Date d = DateTools.stringToDate((String)t.text());
            return new DateParameter(this.name(), d, this._resolution, false).toQuery();
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid facet date {} for field {}", new Object[]{t.text(), this.name(), ex});
            return new TermQuery(t);
        }
    }

    @Override
    public String getType() {
        return "date-range";
    }

    @Override
    protected FlexibleRangeFacet.Range findRange(Term t) {
        Date d;
        if (t == null || t.text() == null || t.text().isEmpty()) {
            return null;
        }
        try {
            d = DateTools.stringToDate((String)t.text());
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid facet date {} for field {}", new Object[]{t.text(), this.name(), ex});
            return null;
        }
        for (OptimisedRange r : this._ranges) {
            boolean passMax;
            boolean passMin = r.min == null || r.min.before(d) || r.original.includeMin() && r.min.equals(d);
            boolean bl = passMax = r.max == null || d.before(r.max) || r.original.includeMax() && r.max.equals(d);
            if (!passMin || !passMax) continue;
            return r.original;
        }
        return null;
    }

    @Override
    protected void rangeToXML(FlexibleRangeFacet.Range range, int cardinality, XMLWriter xml) throws IOException {
        try {
            String fmin = range.getMin() == null ? null : Dates.format(DateTools.stringToDate((String)range.getMin()), this._resolution);
            String fmax = range.getMax() == null ? null : Dates.format(DateTools.stringToDate((String)range.getMax()), this._resolution);
            Dates.dateRangeToXML("range", fmin, fmax, range.includeMin(), range.includeMax(), cardinality, xml);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private class OptimisedRange {
        private Date min = null;
        private Date max = null;
        private final FlexibleRangeFacet.Range original;
        private boolean invalid = false;

        private OptimisedRange(FlexibleRangeFacet.Range range) {
            this.original = range;
            try {
                this.min = range.getMin() == null ? null : DateTools.stringToDate((String)range.getMin());
            }
            catch (ParseException ex) {
                LOGGER.warn("Ignoring invalid facet range date {} for field {}", new Object[]{range.getMin(), DateRangeFacet.this._name, ex});
                this.invalid = true;
            }
            try {
                this.max = range.getMax() == null ? null : DateTools.stringToDate((String)range.getMax());
            }
            catch (ParseException ex) {
                LOGGER.warn("Ignoring invalid facet range date {} for field {}", new Object[]{range.getMax(), DateRangeFacet.this._name, ex});
                this.invalid = true;
            }
        }
    }

    private static class DateRange {
        private Date min;
        private Date max;
        private boolean withMin;
        private boolean withMax;

        private DateRange() {
        }
    }

    public static class Builder {
        private final List<DateRange> dateranges = new ArrayList<DateRange>();
        private final List<FlexibleRangeFacet.Range> ranges = new ArrayList<FlexibleRangeFacet.Range>();
        private DateTools.Resolution resolution = null;
        private String name = null;

        public Builder resolution(DateTools.Resolution res) {
            this.resolution = res;
            return this;
        }

        public Builder name(String n) {
            this.name = n;
            return this;
        }

        public Builder addRange(Date min, boolean withMin, Date max, boolean withMax) {
            DateRange dr = new DateRange();
            dr.min = min;
            dr.max = max;
            dr.withMax = withMax;
            dr.withMin = withMin;
            this.dateranges.add(dr);
            return this;
        }

        public Builder addRange(Date min, Date max) {
            return this.addRange(min, true, max, true);
        }

        public Builder addRange(FlexibleRangeFacet.Range range) {
            this.ranges.add(range);
            return this;
        }

        public DateRangeFacet build() {
            if (this.name == null) {
                throw new IllegalStateException("Must have a field name");
            }
            if (this.resolution == null) {
                throw new IllegalStateException("Must have a resolution");
            }
            for (DateRange dr : this.dateranges) {
                this.ranges.add(FlexibleRangeFacet.Range.dateRange(dr.min, dr.withMin, dr.max, dr.withMax, this.resolution));
            }
            return new DateRangeFacet(this.name, this.resolution, this.ranges);
        }
    }
}

