/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.LuceneUtils;
import org.pageseeder.flint.lucene.util.Dates;

public class FlintDocumentConverter {
    private final Map<String, String> warnings = new HashMap<String, String>();

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public Collection<String> fieldsWithWarnings() {
        return this.warnings.keySet();
    }

    public String getWarning(String field) {
        return this.warnings.get(field);
    }

    public List<Document> convert(List<FlintDocument> fdocs) {
        HashMap<String, FlintField> forCatalog = new HashMap<String, FlintField>();
        ArrayList<Document> docs = new ArrayList<Document>();
        for (FlintDocument fdoc : fdocs) {
            Document doc = new Document();
            for (FlintField field : fdoc.fields()) {
                List<Field> thefields;
                if (Catalogs.updateField((FlintField)field)) {
                    this.warnings.put(field.name(), "field has been updated because of a different definition in the catalog");
                }
                if ((thefields = this.toFields(field, forCatalog)) != null) {
                    for (Field thefield : thefields) {
                        doc.add((IndexableField)thefield);
                    }
                    continue;
                }
                this.warnings.put(field.name(), "field is ignored because it is invalid");
            }
            for (FlintField ff : forCatalog.values()) {
                if (ff.catalog() == null) continue;
                Catalogs.newField((String)ff.catalog(), (FlintField)ff);
            }
            docs.add(doc);
        }
        return docs;
    }

    private List<Field> toFields(FlintField ffield, Map<String, FlintField> forCatalog) {
        List<Field> fields;
        if (ffield.name() == null) {
            throw new IllegalStateException("Unable to build field, field name not set");
        }
        if (ffield.index() == null) {
            throw new IllegalStateException("Unable to build field, field index not set");
        }
        if (ffield.value() == null) {
            throw new IllegalStateException("Unable to build field, field value not set");
        }
        if (ffield.isDocValues()) {
            fields = this.toDocValuesFields(ffield);
            if (fields != null) {
                forCatalog.put(ffield.name(), ffield);
            }
        } else {
            Field main;
            fields = this.toNormalFields(ffield);
            if (!fields.isEmpty() && (main = fields.get(0)).fieldType() != null && main.fieldType().indexOptions() != IndexOptions.NONE && !forCatalog.containsKey(ffield.name())) {
                forCatalog.put(ffield.name(), ffield);
            }
        }
        return fields;
    }

    private List<Field> toNormalFields(FlintField ffield) {
        String value = ffield.value().toString();
        ArrayList<Field> fields = new ArrayList<Field>();
        if (ffield.numeric() != null) {
            Field field = this.toDateOrNumericField(ffield);
            if (field != null) {
                fields.add(field);
            }
        } else if (ffield.dateformat() != null) {
            Date date = value.isEmpty() ? null : this.toDate(ffield.name(), value, ffield.dateformat());
            fields.add(new Field(ffield.name(), (CharSequence)(date != null ? Dates.toString(date, LuceneUtils.toResolution(ffield.resolution())) : ""), (IndexableFieldType)FlintDocumentConverter.toType(ffield)));
        } else {
            fields.add(new Field(ffield.name(), (CharSequence)value, (IndexableFieldType)FlintDocumentConverter.toType(ffield)));
        }
        return fields;
    }

    private List<Field> toDocValuesFields(FlintField ffield) {
        ArrayList<Field> fields = new ArrayList<Field>();
        switch (ffield.docValues()) {
            case FORCED_NONE: {
                return null;
            }
            case SORTED_NUMERIC: {
                Field field = this.toDateOrNumericField(ffield);
                if (field == null) break;
                fields.add(field);
                break;
            }
            case SORTED: 
            case SORTED_SET: {
                BytesRef bytes;
                String value;
                String name = ffield.name();
                if (ffield.dateformat() != null) {
                    String date = Dates.toString(this.toDate(name, ffield.value().toString(), ffield.dateformat()), LuceneUtils.toResolution(ffield.resolution()));
                    value = date == null ? "" : date;
                    bytes = new BytesRef((CharSequence)value);
                } else {
                    value = ffield.value().toString();
                    bytes = new BytesRef(ffield.value());
                }
                fields.add(new Field(name, (CharSequence)value, (IndexableFieldType)FlintDocumentConverter.toType(ffield)));
                fields.add((Field)(ffield.docValues() == FlintField.DocValuesType.SORTED_SET ? new SortedSetDocValuesField(name, bytes) : new SortedDocValuesField(name, bytes)));
            }
        }
        return fields;
    }

    private Field toDateOrNumericField(FlintField ffield) {
        Field.Store stored;
        if (ffield.numeric() == null) {
            return null;
        }
        String name = ffield.name();
        String value = ffield.value().toString();
        Field.Store store = stored = ffield.store() ? Field.Store.YES : Field.Store.NO;
        if (ffield.dateformat() != null) {
            Number date = Dates.toNumber(this.toDate(name, value, ffield.dateformat()), LuceneUtils.toResolution(ffield.resolution()));
            if (date instanceof Long) {
                return new LongField(name, date.longValue(), stored);
            }
            if (date instanceof Integer) {
                return new IntField(name, date.intValue(), stored);
            }
            this.warnings.put(ffield.name(), "ignoring field as it has a date format but no date");
        } else {
            try {
                switch (ffield.numeric()) {
                    case DOUBLE: {
                        return new DoubleField(name, Double.parseDouble(value), stored);
                    }
                    case FLOAT: {
                        return new FloatField(name, Float.parseFloat(value), stored);
                    }
                    case LONG: {
                        return new LongField(name, Long.parseLong(value), stored);
                    }
                    case INT: {
                        return new IntField(name, Integer.parseInt(value), stored);
                    }
                }
            }
            catch (NumberFormatException ex) {
                this.warnings.put(ffield.name(), "ignoring number field with invalid value '" + value + "'");
            }
        }
        return null;
    }

    private static FieldType toType(FlintField ffield) {
        FieldType type = new FieldType();
        type.setStored(ffield.store());
        type.setTokenized(ffield.tokenize());
        type.setIndexOptions(FlintDocumentConverter.toIndexOptions(ffield.index()));
        if (ffield.index() != FlintField.IndexOptions.NONE) {
            type.setOmitNorms(ffield.omitNorms());
            type.setStoreTermVectors(ffield.termVector());
            type.setStoreTermVectorOffsets(ffield.termVectorOffsets());
            type.setStoreTermVectorPositions(ffield.termVectorPositions());
            type.setStoreTermVectorPayloads(ffield.termVectorPayloads());
        }
        return type;
    }

    private static IndexOptions toIndexOptions(FlintField.IndexOptions options) {
        if (options == null) {
            return null;
        }
        switch (options) {
            case NONE: {
                return IndexOptions.NONE;
            }
            case DOCS: {
                return IndexOptions.DOCS;
            }
            case DOCS_AND_FREQS: {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        return null;
    }

    private Date toDate(String name, String value, SimpleDateFormat format) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return format.parse(value);
        }
        catch (ParseException ex) {
            this.warnings.put(name, "ignoring unparseable date '" + value + "' with format '" + format.toPattern() + "'");
            return null;
        }
    }
}

