<!--
  ~ Copyright (c) 1999-2025. Allette Systems Pty Ltd
  -->

<!--
  Get properties for validation

  @author Philip Rutherford
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
  
  <xsl:output method="text" />
  
  <xsl:template match="/">
    <xsl:if test="//svrl:failed-assert">
      <xsl:text>validation.documents=</xsl:text>
      <xsl:value-of select="/validation-report/@documents" />
      <xsl:text>&#xA;</xsl:text>
      <xsl:text>validation.first_uriid=</xsl:text>
      <xsl:value-of select="(//uri)[1]/@id" />
      <xsl:text>&#xA;</xsl:text>
      <xsl:text>validation.has_error=</xsl:text>
      <xsl:value-of select="count(//svrl:failed-assert[@id='HAS_ERROR'])" />
      <xsl:text>&#xA;</xsl:text>
      <xsl:text>validation.not_found=</xsl:text>
      <xsl:value-of select="count(//svrl:failed-assert[@id='NOT_FOUND'])" />
      <xsl:text>&#xA;</xsl:text>
      <xsl:text>validation.redirect=</xsl:text>
      <xsl:value-of select="count(//svrl:failed-assert[@id='REDIRECT'])" />
      <xsl:text>&#xA;</xsl:text>
      <xsl:text>validation.requires_authentication=</xsl:text>
      <xsl:value-of select="count(//svrl:failed-assert[@id='REQUIRES_AUTHENTICATION'])" />
      <xsl:text>&#xA;</xsl:text>
      <xsl:text>validation.unreachable=</xsl:text>
      <xsl:value-of select="count(//svrl:failed-assert[@id='UNREACHABLE'])" />
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
  </xsl:template>
  
</xsl:stylesheet>