<?xml version="1.0"?>
<!--
  This schematron checks the status of URLs.
  @version 5.9910
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">

  <sch:title>Validate URL status</sch:title>

  <sch:pattern name="Document">
    <sch:title>Check the URL metadata document</sch:title>

    <sch:rule context="/document/documentinfo/uri">

        <sch:let name="url-metadata"
                 value="document('ps:source-metadata?method=head')"/>

        <sch:report test="$url-metadata/url-source-metadata[@status='ok']"
                    id="OK" flag="info"
        >The URL status is: OK</sch:report>

        <sch:report test="$url-metadata/url-source-metadata[@status='warning']"
                    id="WARNING" flag="tip"
        >The URL status is: WARNING</sch:report>

        <sch:report test="$url-metadata/url-source-metadata[@status='ps_source']"
                    id="PS_SOURCE" flag="tip"
        >The URL status is: PAGESEEDER USER INTERFACE</sch:report>

        <sch:report test="$url-metadata/url-source-metadata[@status='virtual']"
                    id="VIRTUAL" flag="tip"
        >The URL status is: VIRTUAL</sch:report>

        <sch:assert test="$url-metadata/url-source-metadata[not(@status='has_error')]"
                    id="HAS_ERROR" flag="error"
        >The URL status is: HAS ERROR</sch:assert>

        <sch:assert test="$url-metadata/url-source-metadata[not(@status='invalid_host')]"
                    id="INVALID_HOST" flag="error"
        >The URL status is: INVALID HOST</sch:assert>

        <sch:assert test="$url-metadata/url-source-metadata[not(@status='malformed')]"
                    id="MALFORMED" flag="error"
        >The URL status is: MALFORMED URL</sch:assert>

        <sch:assert test="$url-metadata/url-source-metadata[not(@status='not_found')]"
                    id="NOT_FOUND" flag="error"
        >The URL status is: NOT FOUND</sch:assert>

        <sch:assert test="$url-metadata/url-source-metadata[not(@status='redirect')]"
                    id="REDIRECT" flag="warning"
        >The URL status is: REDIRECT</sch:assert>

        <sch:assert test="$url-metadata/url-source-metadata[not(@status='requires_authentication')]"
                    id="REQUIRES_AUTHENTICATION" flag="warning"
        >The URL status is: REQUIRES AUTHENTICATION</sch:assert>

        <sch:assert test="$url-metadata/url-source-metadata[not(@status='unreachable')]"
                    id="UNREACHABLE" flag="error"
        >The URL status is: UNREACHABLE</sch:assert>

        <sch:assert test="$url-metadata/url-source-metadata[not(@status='unsupported_scheme')]"
                    id="UNSUPPORTED_SCHEME" flag="error"
        >The URL status is: UNSUPPORTED SCHEME</sch:assert>

    </sch:rule>

  </sch:pattern>

</sch:schema>
