<!--
  ~ Copyright (c) 1999-2025. Allette Systems Pty Ltd
  -->

<!--
  Check that the reverse title of xrefs matches a heading or numbered paragraph
-->
<sch:pattern id="xref_reversetitle" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <!-- Rule matching xrefs with a reverse title -->
  <sch:rule context="fragment//xref[@reversetitle]|fragment//blockxref[@reversetitle]">

    <!-- The current fragment -->
    <sch:let name="fragment" value="(ancestor::fragment)[1]"/>

    <!-- The first element in the fragment -->
    <sch:let name="first-element" value="$fragment/*[1]"/>

    <!-- The first 'line' in the fragment -->
    <sch:let name="first-line" value="string($first-element)"/>

    <!-- Truncate if necessary (follows the same rule as editor) -->
    <sch:let name="first-line-start"
             value="if (string-length($first-line) gt 40)
         then string-join(tokenize(substring($first-line, 1, 40), ' ')[position() lt last()], ' ')
         else $first-line"/>

    <!-- The first heading in the fragment -->
    <sch:let name="first-heading" value="($fragment//heading)[1]"/>

    <!-- The immediately preceding heading in the document -->
    <sch:let name="previous-heading" value="preceding::heading[1]"/>

    <sch:let name="reverse-title-norm"
             value="if (contains(@reversetitle, ' '))
                  then substring-after(@reversetitle,' ')
                  else @reversetitle"/>

    <!--
      The reverse title should match any of:
      - the first heading
      - the previous heading
      - beginning of the first line in the fragment

      If these elements are numbered, we simply ignore the prefix since it
      isn't available in the source PSML.
    -->
    <sch:report id="xref_reverse_title"
                test="not(@reversetitle = $first-heading
                 or @reversetitle = $previous-heading
                 or starts-with(@reversetitle, $first-line-start)
                 or ($first-heading/@numbered and $reverse-title-norm = $first-heading)
                 or ($previous-heading/@numbered and $reverse-title-norm = $previous-heading)
                 or ($first-element/@numbered and starts-with($reverse-title-norm, $first-line-start)))"
                flag="tip" properties="fragment">
      The reverse title of xref '<sch:value-of select="."/>' does not match any of the following:
      the first heading of the fragment '<sch:value-of select="$first-heading"/>',
      the previous heading in the document '<sch:value-of select="$previous-heading"/>',
      or the beginning of the first line '<sch:value-of select="$first-line-start"/>'.
    </sch:report>

  </sch:rule>

</sch:pattern>