<!--
  Recommend that large fragments be broken up.
-->
<sch:pattern id="max_fragment_size" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
  <sch:title>Max fragments size</sch:title>

  <sch:let name="max-characters" value="2000" />

  <sch:rule context="section[not(@edit='false')]/fragment">

    <sch:report test="string-length(normalize-space(string-join(.//text(), ''))) gt $max-characters"
                id="reached_max_fragment_size"
                properties="fragment" flag="tip"
    >Fragment &#x201C;<sch:value-of select="@id"/>&#x201D; has over <sch:value-of select="$max-characters"/> characters.
      Consider splitting this fragment</sch:report>

  </sch:rule>

</sch:pattern>