<!--
  Check links and xrefs to external URLs
-->
<sch:pattern id="link_checker" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <sch:rule context="(link|xref[@external='true'])[not(ancestor::media-fragment or starts-with(@href,'mailto:'))]">

    <sch:let name="url-metadata"
             value="document(concat('ps:source-metadata?method=head&amp;url=',
                    encode-for-uri(@href)))"/>

    <!-- Broken links -->
    <sch:assert test="$url-metadata/url-source-metadata[@status='ok' or @status='requires_authentication' or @status='redirect']"
                id="broken_link" properties="fragment" flag="error"
    ><sch:value-of select="name()"/> &#x201C;<sch:value-of select="text()"/>&#x201D; is broken:
      unable to access &#x201C;<sch:value-of select="@href"/>&#x201D;.</sch:assert>

    <!-- Broken links -->
    <sch:assert test="not(@archived='true')"
                id="archived_link" properties="fragment" flag="warning"
    ><sch:value-of select="name()"/> &#x201C;<sch:value-of select="text()"/>&#x201D; points to
      an archived URL: &#x201C;<sch:value-of select="@href"/>&#x201D;.</sch:assert>

    <!-- Redirects -->
    <sch:assert test="not(starts-with(@href, 'http://'))"
                id="unsecure_redirect" properties="fragment" flag="warning"
    ><sch:value-of select="name()"/> &#x201C;<sch:value-of select="text()"/>&#x201D; points to an unsecure site.</sch:assert>

    <!-- Redirects -->
    <sch:report test="starts-with(@href, 'https://') and $url-metadata/url-source-metadata[@status='redirect']"
                id="redirect" properties="fragment" flag="info"
    ><sch:value-of select="name()"/> &#x201C;<sch:value-of select="text()"/>&#x201D; redirects to different URL.</sch:report>

    <!-- Report links OK -->
    <sch:report test="$url-metadata/url-source-metadata[@status='ok']"
                id="link_ok"
                properties="fragment"
    ><sch:value-of select="name()"/> &#x201C;<sch:value-of select="text()"/>&#x201D; is valid.</sch:report>

  </sch:rule>

</sch:pattern>