<!--
  Check that the list of terms (place names, brands, etc.) that have a specific capitalization
  appear exactly like that in the text.
-->
<sch:pattern id="always_capitalized" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <sch:let name="always-capitalized"
           value="('Australia', 'PageSeeder', 'Sydney')"/>

  <sch:let name="always-capitalized-regex"
           value="concat('(', string-join($always-capitalized, '|'), ')')"/>

  <sch:rule context="para|block|cell|item|heading">

    <sch:let name="text" value="."/>

    <!-- Terms that should be capitalized -->
    <sch:let name="uncapitalized"
             value="if (matches($text, $always-capitalized-regex, 'i'))
                    then $always-capitalized[replace($text, ., ., 'i') != $text]
                    else ()"/>

    <sch:assert test="empty($uncapitalized)" properties="fragment"
    >Found <sch:value-of select="count($uncapitalized)"/> terms(s) that should be capitalized correctly:
      <sch:value-of select="string-join($uncapitalized, ', ')"/>.</sch:assert>

  </sch:rule>

</sch:pattern>