<xsl:stylesheet version="2.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     exclude-result-prefixes="#all">

 <!-- Citations -->
 <xsl:template match="inline[@label='Citation' and xref]">
   <xsl:for-each select="xref">
     <xref config="citation" display="template">
       <xsl:attribute name="title">({heading})</xsl:attribute>
       <xsl:copy-of select="@*[not(name()='display' or name() = 'title')]" />
       <xsl:apply-templates select="node()" />
     </xref>
     <xsl:if test="contains(., '(pp. ')">
       <inline label="pages">
         <xsl:value-of select="substring-before(substring-after(., '(pp. '), ')')" />
       </inline>
     </xsl:if>
   </xsl:for-each>
 </xsl:template>

 <!-- Paragraph reference -->
 <xsl:template match="inline[@label='PSRefPara' and xref]">
   <xsl:for-each select="xref">
     <xref config="para" display="template">
       <xsl:attribute name="title">{parentnumber}{prefix}</xsl:attribute>
       <xsl:copy-of select="@*[not(name()='display' or name() = 'title')]" />
       <xsl:apply-templates select="node()" />
     </xref>
   </xsl:for-each>
 </xsl:template>

 <!-- Ineternal paragraph reference -->
 <xsl:template match="inline[@label='PSRefInternal' and xref]">
   <xsl:for-each select="xref">
     <xref config="internal-para" display="template">
       <xsl:attribute name="title">{prefix}</xsl:attribute>
       <xsl:copy-of select="@*[not(name()='display' or name() = 'title')]" />
       <xsl:apply-templates select="node()" />
     </xref>
   </xsl:for-each>
 </xsl:template>

 <!-- Numbered heading reference -->
 <xsl:template match="inline[@label='PSRefHeading' and xref]">
   <!-- Collapse double xref -->
   <xsl:if test="not(preceding-sibling::*[1][@label='PSRefHeading'])">
     <xsl:for-each select="xref">
       <xref config="numbered-heading" display="template">
         <xsl:attribute name="title">{prefix} {heading}</xsl:attribute>
         <xsl:copy-of select="@*[not(name()='display' or name() = 'title')]" />
         <xsl:apply-templates select="node()" />
         <xsl:text> </xsl:text>
         <xsl:value-of select="../following-sibling::*[1][@label='PSRefHeading']" />
       </xref>
     </xsl:for-each>
   </xsl:if>
 </xsl:template>

<!-- Caption reference -->
<xsl:template match="inline[@label='PSRefCaption' and xref]">
  <xsl:for-each select="xref">
    <xref config="caption" display="template">
      <xsl:attribute name="title">{prefix}</xsl:attribute>
      <xsl:copy-of select="@*[not(name()='display' or name() = 'title')]" />
      <xsl:apply-templates select="node()" />
    </xref>
  </xsl:for-each>
</xsl:template>

<!-- Bibliography document -->
 <xsl:template match="document[.//block/@label='BibSource']">
   <xsl:copy>
     <xsl:attribute name="type">bibliography</xsl:attribute>
     <xsl:copy-of select="@*[not(name()='type')]" />
     <xsl:apply-templates select="node()" />
   </xsl:copy>
 </xsl:template>

 <!-- Bibliography source -->
 <xsl:template match="fragment[block/@label='BibSource']">
   <xsl:variable name="link-text">
     <xsl:value-of select="(.//inline[@label='Last'])[1]" />
     <xsl:value-of select=".//inline[@label='Corporate']" />
     <xsl:if test=".//inline[@label='Year']">, <xsl:value-of select=".//inline[@label='Year']" /></xsl:if>
   </xsl:variable>
   <properties-fragment id="{@id}" type="citation">
     <property name="link-text" title="Link text" value="{$link-text}"/>
     <property name="description" title="Description" datatype="markup">
       <xsl:copy-of select=".//block[@label='BibSource']/*"/>
     </property>
     <property name="source" title="Source" datatype="xref">
     </property>
   </properties-fragment>
 </xsl:template>

 <!-- Table caption -->
 <xsl:template match="block[@label='table-caption']/para/text()[position()=1]">
   <xsl:analyze-string select="." regex="^Table [\d]+-[\d]+[\s]*">
     <xsl:matching-substring />
     <xsl:non-matching-substring>
       <xsl:value-of select="." />
     </xsl:non-matching-substring>
   </xsl:analyze-string>
 </xsl:template>

 <!--Figure caption -->
 <xsl:template match="block[@label='figure-caption']/para/text()[position()=1]">
   <xsl:analyze-string select="." regex="^Fig [\d]+-[\w]+[\s]*">
     <xsl:matching-substring />
     <xsl:non-matching-substring>
       <xsl:value-of select="." />
     </xsl:non-matching-substring>
   </xsl:analyze-string>
 </xsl:template>

 <!-- Ignore section ends -->
 <xsl:template match="block[@label='ps_portrait_end' or @label='ps_landscape_end']">
 </xsl:template>

 <!-- copy all other elements unchanged -->
 <xsl:template match="*">
   <xsl:copy>
     <xsl:copy-of select="@*" />
     <xsl:apply-templates select="node()" />
   </xsl:copy>
 </xsl:template>


</xsl:stylesheet>