<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-group-search' or @service='api-project-search']" mode="json">
  <json:map>
    <xsl:apply-templates select="//results" mode="search-json"/>
  </json:map>
</xsl:template>

<xsl:template match="results" mode="search-json">
  <json:array key="results">
    <xsl:apply-templates select="result" mode="search-json"/>
  </json:array>
</xsl:template>

<xsl:template match="result" mode="search-json">
  <json:map>
    <xsl:for-each-group select="field" group-by="@name">
      <xsl:choose>
        <xsl:when test="@name='psowned' or @name='pseditable'">
          <json:boolean key="{@name}"><xsl:value-of select="."/></json:boolean>
        </xsl:when>
        <xsl:when test="@numeric-type or @name='psxrefcount' or @name='psreversexrefcount' or @name='psgroupid'">
          <json:number key="{@name}"><xsl:value-of select="."/></json:number>
        </xsl:when>
        <xsl:when test="@datetime">
          <json:string key="{@name}"><xsl:value-of select="@datetime"/></json:string>
        </xsl:when>
        <xsl:when test="count(current-group()) gt 1">
          <!-- escape values -->
          <json:string key="{@name}"><xsl:value-of select="string-join(current-group(), ',')"/></json:string>
          <json:array key="{@name}_array">
            <xsl:for-each select="current-group()">
              <json:string><xsl:value-of select="."/></json:string>
            </xsl:for-each>
          </json:array>
        </xsl:when>
        <xsl:otherwise>
          <json:string key="{@name}"><xsl:value-of select="."/></json:string>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each-group>
  </json:map>
</xsl:template>

</xsl:stylesheet>
