<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-document-indexdata']" mode="json">
  <json:map>
    <xsl:for-each select="content/documents">
      <json:string key="version"><xsl:value-of select="@version"/></json:string>
      <json:array key="documents">
        <xsl:for-each select="document">
          <json:map>
            <json:array key="fields">
              <xsl:apply-templates select="field" mode="json-indexdata"/>
            </json:array>
          </json:map>
        </xsl:for-each>
      </json:array>
    </xsl:for-each>
  </json:map>
</xsl:template>

<xsl:template match="document/field" mode="json-indexdata">
  <json:map>
    <json:string key="store"><xsl:value-of select="@store"/></json:string>
    <json:string key="index"><xsl:value-of select="@index"/></json:string>
    <json:boolean key="tokenize"><xsl:value-of select="@tokenize = 'true'"/></json:boolean>
    <json:string  key="name"><xsl:value-of select="@name"/></json:string>
    <json:string  key="value"><xsl:value-of select="."/></json:string>
    <xsl:if test="@doc-values">
      <json:string key="docValues"><xsl:value-of select="@doc-values"/></json:string>
    </xsl:if>
    <xsl:if test="@boost and @boost castable as xs:double">
      <json:number key="boost"><xsl:value-of select="@boost"/></json:number>
    </xsl:if>
    <xsl:if test="@date-format">
      <json:string key="dateFormat"><xsl:value-of select="@date-format"/></json:string>
    </xsl:if>
    <xsl:if test="@date-resolution">
      <json:string key="dateResolution"><xsl:value-of select="@date-resolution"/></json:string>
    </xsl:if>
    <xsl:if test="@numeric-type">
      <json:string key="numericType"><xsl:value-of select="@numeric-type"/></json:string>
    </xsl:if>
  </json:map>
</xsl:template>

</xsl:stylesheet>
