<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-document-fragment-tracker']" mode="json">
  <xsl:variable name="psml-plus-refs">
    <wrap>
      <xsl:copy-of select="content/track-changes/*"/>
    </wrap>
  </xsl:variable>
  <xsl:variable name="html">
    <xsl:apply-templates select="$psml-plus-refs//result/*" mode="psml" />
  </xsl:variable>
  <json:map>
    <json:string key="result">
      <xsl:value-of select="serialize($html)" />
    </json:string>
    <json:array key="edits">
      <!-- Can be `draft` or `edit` -->
      <xsl:for-each select="content/track-changes/edits/edit">
        <json:map>
          <json:number key="id"><xsl:value-of select="@id" /></json:number>
          <json:string key="created"><xsl:value-of select="@created" /></json:string>
          <xsl:apply-templates select="author" mode="json" />
          <xsl:if test="notes/note">
            <json:array key="notes">
              <xsl:apply-templates select="notes/note" mode="json-document" />
            </json:array>
          </xsl:if>
        </json:map>
      </xsl:for-each>
    </json:array>
  </json:map>
</xsl:template>

</xsl:stylesheet>
