<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-auth']" mode="json">
  <json:map>
    <json:string key="status"><xsl:value-of select="content/root/status"/></json:string>
    <xsl:for-each select="content/root">
      <xsl:for-each select="title|message|location|lastusername">
        <json:string key="{name()}"><xsl:value-of select="."/></json:string>
      </xsl:for-each>
      <xsl:if test="member">
        <json:string key="email"><xsl:value-of select="email"/></json:string>
        <!-- TODO is the member info required? -->
        <json:map key="member">
          <json:number key="id"><xsl:value-of select="member/id"/></json:number>
          <json:string key="firstname"><xsl:value-of select="member/firstname"/></json:string>
          <json:string key="surname"><xsl:value-of select="member/surname"/></json:string>
          <json:string key="username"><xsl:value-of select="member/username"/></json:string>
          <json:string key="fullname"><xsl:value-of select="concat(member/firstname, ' ', member/surname)"/></json:string>
        </json:map>
      </xsl:if>
    </xsl:for-each>
  </json:map>
</xsl:template>

</xsl:stylesheet>