<!--
  ~ Copyright (c) 1999-2021. Allette Systems Pty Ltd
  -->
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<!-- Server settings -->
<xsl:template match="root[@service='api-admin-server-properties']" mode="json">
  <xsl:variable name="settings" select="content//property"/>
  <json:array>
    <xsl:for-each select="$definitions//set">
      <json:map>
        <json:string key="title"><xsl:value-of select="@title" /></json:string>
        <json:string key="type"><xsl:value-of select="@type" /></json:string>
        <xsl:sequence select="f:_admin-settings-properties($settings, .)" />
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:template>

<xsl:function name="f:_admin-settings-properties">
  <xsl:param name="settings"/>
  <xsl:param name="set"/>
  <xsl:variable name="dset" select="if ($set/@type = 'project') then $definitions//set[@type='group'] else $set" />
  <json:array key="properties">
    <xsl:for-each select="$settings[f:filter-groupproperty($set, .)]">
      <xsl:sort select="@name"/>
      <xsl:variable name="definition" select="$dset/setting[@name = current()/@name]"/>
      <xsl:variable name="is-default"  select="$definition/@default = @value or (string(@value) = '' and $definition/@default = '')"/>
      <json:map>
        <json:string key="name"><xsl:value-of select="@name"/></json:string>
        <json:string key="value"><xsl:value-of select="if (@name = 'EncryptedPassword') then string-join(tokenize(@value, '\.'), '.&#x200B;') else @value"/></json:string>
        <xsl:if test="$definition/@usage">
          <json:string key="usage"><xsl:value-of select="$definition/@usage"/></json:string>
        </xsl:if>
        <xsl:if test="$definition/@default">
          <json:string key="defaultValue"><xsl:value-of select="$definition/@default"/></json:string>
        </xsl:if>
        <xsl:if test="$definition/@deprecated">
          <json:boolean key="deprecated">true</json:boolean>
        </xsl:if>
        <xsl:if test="$definition/@obsolete">
          <json:boolean key="obsolete">true</json:boolean>
        </xsl:if>
        <xsl:if test="not($is-default) and not($dset/@override = 'false')">
          <json:boolean key="specific">true</json:boolean>
        </xsl:if>
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:function>

<xsl:function name="f:filter-groupproperty">
  <xsl:param name="set"     />
  <xsl:param name="setting" />
  <xsl:sequence select="$set/@type = $setting/../@type"/>
</xsl:function>

<!-- Definitions -->
<xsl:variable name="definitions">
  <definitions>
    <!-- Global Properties -->
    <set type="global" title="Global properties">
      <setting name="adminEnable"                                   usage="Allowed values: delete-comments,delete-documents,admin-database,set-style-owner"/>
      <setting name="apiAccountUsernames"                           usage="Comma separated list of API account usernames (apiAccountIPs must also be set). API account passwords cannot be reset"/>
      <setting name="apiPort"                default="8282"         usage="HTTP port used by the Publish Engine to communicate with PageSeeder"/>
      <setting name="attachmentSubDir"       default="attachments"  usage="The folder name within a group to place email attachments"/>
      <setting name="autoResponderLimit"     default="25"           usage="The number of emails allowed to the same locator within the auto responder time before warning emails are sent"/>
      <setting name="autoResponderMinutes"   default="90"           usage="The auto responder time in number of minutes"/>
      <setting name="autoResponderReplyLimit" default="10"          usage="The number of email replies allowed to the same thread within the auto responder time before warning emails are sent"/>
      <setting name="autoResponderWarnings"  default="5"            usage="The number of emails with warnings allowed before comments are rejected."/>
      <setting name="contributorDisable"                            usage="Allowed values: edit-comments,archive-comments,manage-documents"/>
      <setting name="contributorEnable"                             usage="Not currently used"/>
      <setting name="csrfMode"               default="partial-log"  usage="Cross-Site Request Forgery protection. Allowed values: enforce, partial, disable with optional -log suffix."/>
      <setting name="defaultMinimalUI"       default="false"        usage="If 'true' members who have not set a user interface preference will default to using the minimal layout"/>
      <setting name="diffXMaxEvents"         default="4M"           usage="Maximum size of number of words multiplied by number of compare words when diffing content in history"/>
      <setting name="disableDefaultDKIM"     default="false"        usage="A boolean indicating whether to stop signing emails with the pageseeder.com DKIM (use if your SMTP server does the signing)"/>
      <setting name="documentFolder"                                usage="File system path of documents if not using pageseeder/documents folder"/>
      <setting name="emailDomain"                                   usage="The domain to use for emails sent by PageSeeder. If set to pshosts makes incoming and outgoing emails from PageSeeder use the domain of the default folder for the group"/>
      <setting name="emailEmbedImages"       default="false"        usage="A boolean indicating that images in outgoing emails should be embedded as attachments (useful for intranet testing)"/>
      <setting name="emailMaxThreadMessages" default="20"           usage="If the number of recipients for a notification is more than this the emails will be sent in the background"/>
      <setting name="emailSenderDomain"                             usage="A valid domain name required if webSiteAddress is an IP number so that emails from PageSeeder are valid"/>
      <setting name="forbiddenAttachmentExtensions"                 default="ade,adp,apk,appx,appxbundle,bat,cab,chm,cmd,com,cpl,diagcab,diagcfg,diagpack,dll,dmg,ex,ex_,exe,hta,img,ins,iso,isp,jar,jnlp,js,jse,lib,lnk,mde,msc,msi,msix,msixbundle,msp,mst,nsh,pif,ps1,scr,sct,shb,sys,vb,vbe,vbs,vhd,vxd,wsc,wsf,wsh,xll"
                                                                    usage="List of extensions for files which can't be attached to comments as they may be harmful"/>
      <setting name="forbiddenUploadExtensions"                     default="ade,adp,apk,appx,appxbundle,bat,cab,chm,cmd,com,cpl,diagcab,diagcfg,diagpack,dll,dmg,ex,ex_,exe,hta,img,ins,iso,isp,jar,jnlp,js,jse,lib,lnk,mde,msc,msi,msix,msixbundle,msp,mst,nsh,pif,ps1,scr,sct,shb,sys,vb,vbe,vbs,vhd,vxd,wsc,wsf,wsh,xll"
                                                                    usage="List of extensions for files which can only be uploaded by administrators as they may be harmful"/>
      <setting name="globalTemplate"                                usage="A custom project template that applies to all projects on the server"/>
      <setting name="groups"                 default="unlimited"    usage="Number of groups allowed by PageSeeder license or unlimited"/>
      <setting name="licenseExpires"                                usage="The date when the PageSeeder license expires (ISO 8859 format YYYY-MM-DD)"/>
      <setting name="logsAccessHistory"      default="7"            usage="Positive integer corresponding to the number of days the access log history is kept"/>
      <setting name="logsAccessLevel"        default="INFO"         usage="Types of access that will be logged, must be one of DEBUG, INFO, WARN, ERROR, OFF"/>
      <setting name="logsFolder"                                    usage="Absolute folder path for log files"/>
      <setting name="mailIp"                                        usage="IP address to bind PageSeeder email server to in not all IPs"/>
      <setting name="mailPort"               default="25"           usage="Port for PageSeeder email server"/>
      <setting name="mailServer"             default="true"         usage="A boolean indicating that the PageSeeder mail server should be enabled"/>
      <setting name="mailTlsCertificate"                            usage="Absolute folder path to certificate for TLS on incoming email"/>
      <setting name="mailTlsKey"                                    usage="Absolute folder path to key for TLS on incoming email"/>
      <setting name="mailTlsRequired"        default="false"        usage="A boolean indicating that TLS must be used (requires mailTlsKey and mailTlsCertificate)"/>
      <setting name="malwareMaxEmailThreads" default="0"            usage="The maximum number of email threads that can scan for malware simultaneously"/>
      <setting name="malwareScanner"                                usage="The [host]:[port] for the ClamAV malware scanner"/>
      <setting name="malwareScanUIOnly"      default="false"        usage="A boolean indicating to only scan files uploaded via the user interface"/>
      <setting name="managerDisable"                                usage="Allowed values: edit-comments,archive-comments,edit-docids"/>
      <setting name="managerEnable"                                 usage="Allowed values: delete-comments"/>
      <setting name="manualTokenCreation"    default="false"        usage="Allow administrators to manually issue tokens and authorization codes"/>
      <setting name="maxAccountLockout"      default="60"           usage="The maximum number of minutes an account can be locked for"/>
      <setting name="maxAttachmentNumber"    default="20"           usage="The maximum number of files that can be attached to a comment"/>
      <setting name="maxAttachmentSize"      default="10M"          usage="The maximum size of an attachment in a notification email in bytes"/>
      <setting name="maxAutosuggestPrefixes" default="800"          usage="The maximum number of prefixes in the autosuggest query, if too high autosuggest will fail
                                                                           when querying small terms in big indexes (should not be more than 1000)"/>
      <setting name="maxBadLogins"           default="10"           usage="The maximum number of incorrect logins before an account is locked"/>
      <setting name="maxFacetSize"           default="1000"         usage="The maximum number of facets that can be returned by the search"/>
      <setting name="maxForwardXRefs"        default="3000"         usage="The maximum number forward XRefs in a document"/>
      <setting name="maxIndexingSize"        default="30M"          usage="Non-PSML files with larger than this number of bytes will not have their content indexed"/>
      <setting name="maxIndexingThreads"     default="2"            usage="The maximum number of indexing threads"/>
      <setting name="maxOpenedIndexes"       default="50"           usage="The maximum number of indexes which can be open at one time"/>
      <setting name="maxPageSize"            default="10000"        usage="The maximum number of results on all pages"/>
      <setting name="maxReverseXRefs"        default="1000"         usage="The maximum number reverse XRefs in a document"/>
      <setting name="maxUploadNotificationAttachments" default="20" usage="The maximum number of document attachments on an upload notification"/>
      <setting name="maxUploadSize"          default="100M"         usage="The maximum size in bytes for files being uploaded"/>
      <setting name="maxVersionNotifications"  default="20"         usage="The maximum number of notifications when adding bulk versions by upload, folder or search"/>
      <setting name="maxWorkflowNotifications" default="20"         usage="The maximum number of notifications when adding bulk workflows by upload, folder or search"/>
      <setting name="members"                default="unlimited"    usage="Number of members allowed by PageSeeder license or unlimited"/>
      <setting name="mfaDisable"             default="false"        usage="If 'true' disable MFA on sign-in"/>
      <setting name="mfaSupport" default="email-otp,totp,recovery"  usage="List of supported multi-factor authentication types (allowed values: email-otp,sms-otp,totp,recovery,webauthn)"/>
      <setting name="minAccountLockout"      default="30"           usage="The minimum number of minutes an account can be locked for"/>
      <setting name="minBadLogins"           default="5"            usage="The maximum number of incorrect logins before an account is locked"/>
      <setting name="notifyDailyTime"        default="23:59"        usage="Time in 24 hour format when daily comment notifications are sent out"/>
      <setting name="notifyProcess"          default="true"         usage="A boolean indicating that daily comment notifications should be enabled"/>
      <setting name="notifyWeeklyDay"        default="sunday"       usage="The day that weekly comment notifications are sent out (they are sent at the notifyDailyTime)"/>
      <setting name="outOfOfficeLimit"       default="2"            usage="Number of emails matching outOfOfficeString allowed before member is set to 'on vacation'"/>
      <setting name="outOfOfficeString" default="out of the office,out of office" usage="Comma separated list of strings to look for in email subject if not out of the office"/>
      <setting name="passwordAlgorithm"      default="p5"/>
      <setting name="productKey"             default="dev"          usage="Product key for PageSeeder license"/>
      <setting name="projects"               default="unlimited"    usage="Number of projects allowed by PageSeeder license or unlimited"/>
      <setting name="publishEngineUrl"                              usage="URL for Publish Engine if installed on a separate server"/>
      <setting name="reminderMaxEmails"      default="2000"         usage="The maximum number of reminder emails allowed to be sent each week"/>
      <setting name="reminderNotification"   default="false"        usage="If 'true' enable sending of reminder emails"/>
      <setting name="reminderStatuses"       default="Open,Initiated,In Progress,Complete" usage="Comma separated list of statuses a task/workflow must have to be in reminders"/>
      <setting name="reminderTime"           default="04:00"        usage="Time in 24 hour format to start sending reminders every Monday"/>
      <setting name="reviewerEnable"                                usage="Allowed values: assign-all-comments,create-workflow"/>
      <setting name="serviceStrict"          default="log"          usage="If 'true' an HTTP error is returned for deprecated or non-released services. If 'log' just a warning is logged."/>
      <setting name="servletPrefix"          default="/ps/servlet"  usage="The path used to access PageSeeder servlets as defined in the Web configuration (web.xml)"/>
      <setting name="sitePrefix"             default="/ps"          usage="The path of the PageSeeder application as defined in the Web configuration (web.xml)"/>
      <setting name="slowIndexingSize"       default="1M"           usage="Non-PSML files with larger than this number of bytes join the slow indexing queue to conserve memory"/>
      <setting name="smsProvider"                                   usage="The name of the SMS provider for MFA"/>
      <setting name="smsProviderApiKey"                             usage="The SMS API service ID for MFA"/>
      <setting name="smsProviderApiSecret"                          usage="The SMS API secret for MFA"/>
      <setting name="smsProviderServiceId"                          usage="The name of the SMS provider for MFA"/>
      <setting name="smtpAsync"              default="false"        usage="Send all emails asynchronously by default"/>
      <setting name="smtpServerAddress"      default=""             usage="SMTP server to use for outgoing email messages"/>
      <setting name="smtpServerPort"         default="25"           usage="Port of SMTP server to use for outgoing email messages"/>
      <setting name="smtpServerUsername"     default=""             usage="Username to connect to SMTP server for outgoing email messages"/>
      <setting name="smtpServerPassword"     default=""             usage="Password to connect to SMTP server to use for outgoing email messages (not displayed)"/>
      <setting name="smtpServerSSL"          default="false"        usage="If 'true' connect to SMTP server using SSL for outgoing email messages"/>
      <setting name="smtpServerSTARTTLS"     default="false"        usage="If 'true' connect to SMTP server using START TLS for outgoing email messages"/>
      <setting name="urlRequestDelay"        default="10"           usage="The delay in seconds between requests to the same domain when validating URLs"/>
      <setting name="webhookRequestInterval" default="5"            usage="The number of seconds to collect webook events into a batch before sending as a single request"/>
      <setting name="webhookRequestSize"     default="1400"         usage="The maximum number of bytes in a single webhook request"/>
      <setting name="webhookRetries"         default="12"           usage="The maximum number of times a failed webhook request will be resent"/>
      <setting name="webSiteAddress"                                usage="Specifies the host of PageSeeder; must be a valid host name"/>
      <setting name="webSitePort"            default="443"          usage="The port to access PageSeeder; must be a valid port number"/>
      <setting name="webSiteScheme"          default="https"        usage="Specifies the URL Scheme used to access PageSeeder. Supported values: http or https"/>

      <!-- Deprecated -->
      <setting name="customFolder"           deprecated="true" usage="Use 'globalTemplate' property instead"/>
      <setting name="topics"                 deprecated="true" usage="Use 'groups' property instead"/>

      <!-- Obsolete -->
      <setting name="anchorPrefix"           obsolete="true" usage="Prefix used for PageSeeder HTML anchor names"/>
      <setting name="attachmentDir"          obsolete="true" usage="File system path to save email attachments or internal to save them in PageSeeder"/>
      <setting name="autoNoSeed"             obsolete="true" />
      <setting name="autoSeed"               obsolete="true" />
      <setting name="autoToolbar"            obsolete="true" />
      <setting name="backupExtension"        obsolete="true" usage="The file extension for the backup copy of a HTML file before it is seeded"/>
      <setting name="contentLineLength"      obsolete="true" usage="Maximum line length when sending plain text email messages"/>
      <setting name="country"                obsolete="true" />
      <setting name="customPackage"          obsolete="true" usage="Package name for customized java classes (requires a special license)"/>
      <setting name="documentPort"           obsolete="true" usage="The port for document URIs in PageSeeder"/>
      <setting name="documentScheme"         obsolete="true" usage="The scheme for document URIs in PageSeeder"/>
      <setting name="htmlOutputEncoding"     obsolete="true" />
      <setting name="htmlSourceEncoding"     obsolete="true" />
      <setting name="ignoreExtensions"       obsolete="true" />
      <setting name="ignorePrefix"           obsolete="true" usage="List of prefixes for folders/files that should not be displayed when browsing documents"/>
      <setting name="indexExtension"         obsolete="true" usage="Index information file"/>
      <setting name="language"               obsolete="true" />
      <setting name="linkSeeds"              obsolete="true"/>
      <setting name="mailRelay"              obsolete="true" usage="List of IP addresses that are allowed to send email using the PageSeeder email server"/>
      <setting name="mailReturnedAddress"    obsolete="true" />
      <setting name="manualExtension"        obsolete="true" />
      <setting name="notifyFromAddress"      obsolete="true"/>
      <setting name="originalExtension"      obsolete="true" usage="The file extension for the original copy of a HTML file before it is seeded"/>
      <setting name="redirectPort"           obsolete="true" usage="Comma separated list of TCP ports which will be redirected to webSitePort in template.properties (e.g. 80,8080)"/>
      <setting name="reviewMaxXLinks"        obsolete="true"/>
      <setting name="searchMaxXLinks"        obsolete="true"/>
      <setting name="servletApi"             obsolete="true"/>
      <setting name="sessionPrefix"          obsolete="true" />
      <setting name="style"                  obsolete="true"/>
      <setting name="templateDir"            obsolete="true"/>
      <setting name="treeMaxObjects"         obsolete="true"/>
      <setting name="version6"               obsolete="true"/>
      <setting name="warConfig"              obsolete="true"/>
      <setting name="webExtension"           obsolete="true" usage="The file extension which can be used as an alias for manualExtension when access the file" />

    </set>
    <!-- Database Properties -->
    <set type="database" title="Database properties">
      <setting name="DBDriver"       usage="The name of the class implementing the JDBC Driver interface"/>
      <setting name="DBURL"          usage="The JDBC URL to access the database"/>
      <setting name="HostName"       usage="The name of the machine hosting the MySQL database server"/>
      <setting name="LoginPassword"  usage="The password to access the MySQL database"/>
      <setting name="LoginName"      usage="The login to access the MySQL database"/>
      <setting name="DatabaseName"   usage="The name of the MySQL database"/>
      <setting name="DatabaseType"   usage="The type of database used"/>
    </set>
    <set type="group" title="Group properties">
      <setting name="acceptInvitationRequired"   default="true"                   usage="Do members need to accept an invitation to join a group. Allowed values are 'true' or 'false'"/>
      <setting name="disableIndexing"           default="false"                   usage="Flag to disable indexing on group"/>
      <setting name="documentStatusApprover"    default="Initiated,In Progress,Complete,Approved,Suspended,Terminated" usage="The list of statuses that Approvers can use for a document - order reflects the lifecycle of a document"/>
      <setting name="documentStatusContributor" default="In Progress,Complete"    usage="The list of statuses that Contributors can use for a document - order reflects the lifecycle of a document"/>
      <setting name="documentStatusIcon"        default="open,open,resolved,approved,closed,closed" usage="The list of icons corresponding to documentStatusApprover values in same order - can be open,resolved,approved or closed"/>
      <setting name="documentStatusLocked"      default=""                        usage="The list of statuses for which editing via the user interface is disabled"/>
      <setting name="documentStatusManager"     default="Initiated,In Progress,Complete,Suspended,Terminated" usage="The list of statuses that Managers can use for a document - order reflects the lifecycle of a document"/>
      <setting name="documentStatusReviewer"    default="In Progress,Complete"    usage="The list of statuses that Reviewers can use for a document - order reflects the lifecycle of a document"/>
      <setting name="emailFooterStart"          default="--------------------------------------,Type response above" usage="Strip the text footer content of an email posted to PageSeeder starting with this text"/>
      <setting name="errorReportAddress"        default="ps-support@ps.pageseeder.com" usage="The email address that PageSeeder error reports will be sent to"/>
      <setting name="ignoreEmbeddedAttachmentSize" default="20000"                usage="Embedded files in incoming emails below this number of bytes will be ignored"/>
      <setting name="indexIgnoreFolders"        default="download"                usage="A comma separated list of root folders that will be ignored when indexing the group"/>
      <setting name="indexVersions"             default="false"                   usage="Flag to index document versions"/>
      <setting name="indexXFields"              default="false"                   usage="Flag to index all fields extracted from documents by Tika and prefix their name with 'x-'"/>
      <setting name="mailNewThreadByTitle"      default="false"                   usage="A boolean indicating if the subject line is changed when replying to a comment by email a new thread is created"/>
      <setting name="mailRejectedAddress"       default=""                        usage="Email address to forward messages which are rejected because the sender does not have access rights"/>
      <setting name="mailReturnedAddress"       default=""                        usage="When notifyFromAddress is set to groupReturned, any messages will be sent to this address instead of sending all returns to the Member that posted the message"/>
      <setting name="notifyFromAddress"         default="noreply"                 usage="What to put as the From: address in PageSeeder email messages"/>
      <setting name="priority"                  default="High,Medium,Low"         usage="The list of priorities ordered from highest to lowest"/>
      <setting name="reminderNotification"      default="false"                   usage="A boolean indicating to send reminder emails for due tasks in this project or group"/>
      <setting name="statusActive"              default="Open,Initiated,In Progress,Complete" usage="The list of statuses that are considered active"/>
      <setting name="statusApprover"            default="Open,Resolved,Closed"    usage="The list of statuses that approvers can use for a task - order reflects the lifecycle of a task"/>
      <setting name="statusBroadcastApprovers"  default="Resolved,Complete"       usage="The list of statuses which when set will cause an email notification to be sent to Approvers for the group"/>
      <setting name="statusContributor"         default="Open,Resolved"           usage="The list of statuses that contributors can use for a task - order reflects the lifecycle of a task"/>
      <setting name="statusIcon"                default="open,resolved,closed"    usage="The list of icons corresponding to statusApprover values in same order - can be open,resolved,approved or closed"/>
      <setting name="statusManager"             default="Open,Resolved"           usage="The list of statuses that managers can use for a task - order reflects the lifecycle of a task"/>
      <setting name="statusReviewer"            default="Open"                    usage="The list of statuses that reviewers can use for a task - order reflects the lifecycle of a task"/>
      <setting name="stripHtmlEmailFooter"      default="true"                    usage="A boolean indicating to strip the PageSeeder email footer from HTML emails posted to PageSeeder"/>
      <!-- Deprecated -->
      <setting name="contentEditorName"         deprecated="true"/>
      <setting name="customCss"                 deprecated="true"                 usage="A boolean value indicating whether the group uses custom CSS"/>
      <setting name="defaultStyleView"          deprecated="true"/>
      <setting name="documentStatusInitial"     deprecated="true"/>
      <setting name="documentTimeVersionStatic" deprecated="true"                 usage="Comma separated list of default versions used when creating document versions"/>
      <setting name="documentTimeVersionIncrementing" deprecated="true"           usage="The default increment to add to the previous version when creating document versions"/>
      <setting name="emailFooterEnd"            deprecated="true"                 usage="Strip the text footer content of an email posted to PageSeeder ending with this text"/>
      <setting name="helpUrl"                   deprecated="true"                 usage="The URL of the Help link"/>
      <setting name="shareDocumentEdits"        deprecated="true"                 usage="Flag to allow edits made on documents in the default folder of the group that are shared between two or more groups to be visible to all the groups"/>
      <setting name="shareXrefsWithTarget"      deprecated="true"                 usage="Flag to allow XRefs added to a documents in the default folder of the group to be visible on the target document's group(s) as a reverse XRef"/>
      <setting name="statusChangeBroadcast"     deprecated="true"                 usage="Flag to send an email notification to all authors of a task when a status, assignee, priority or due date is changed"/>
      <setting name="styleViews"                deprecated="true"/>
      <!-- Obsolete -->
      <setting name="headerLogoUrl"             obsolete="true"/>
      <setting name="inlineContentLabels"       obsolete="true"/>
      <setting name="paraContentLabels"         obsolete="true"/>
      <setting name="xrefContentLabels"         obsolete="true"/>
      <setting name="generalLabels"             obsolete="true"/>
    </set>
    <set type="project"  title="Project properties"/>
    <set type="jdo"      title="JDO properties"      override="false"/>
    <set type="mime"     title="MIME properties"     override="false"/>
  </definitions>
</xsl:variable>

</xsl:stylesheet>
