<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-logs-index-ticket' or
                          @service='api-group-admin-logs-index-ticket']" mode="json">
  <xsl:variable name="ticket-id" select="//parameter[@name='ticket']"/>
  <xsl:variable name="ticket" select="//ticket[@id=$ticket-id]"/>
  <json:map>
    <xsl:apply-templates select="$ticket" mode="json">
      <xsl:with-param name="key">ticket</xsl:with-param>
      <xsl:with-param name="indexing" select="true()"/>
    </xsl:apply-templates>
    <xsl:if test="not($ticket)">
      <json:null key="ticket"/>
    </xsl:if>
    <xsl:if test="content/events/@more = 'true'"><json:boolean key="more">true</json:boolean></xsl:if>
    <json:array key="events">
      <xsl:variable name="events" select="//event" />
      <xsl:for-each-group select="$events" group-by="if (job/@contentid) then job/@contentid else @type">
        <xsl:variable name="first" select="current-group()[1]"/>
        <json:map>
          <json:number key="timestamp"><xsl:value-of select="f:timestamp-micro($first)"/></json:number>
          <json:string key="datetime"><xsl:value-of select="$first/@datetime"/></json:string>
          <json:string key="level">
            <xsl:choose>
              <xsl:when test="current-group()/job[lower-case(@type) = 'warn']">WARN</xsl:when>
              <xsl:when test="current-group()/job[lower-case(@type) = 'fail']">ERROR</xsl:when>
              <xsl:otherwise>INFO</xsl:otherwise>
            </xsl:choose>
          </json:string>
          <json:string key="icon">
            <xsl:choose>
              <xsl:when test="$first/job[@contentid = 'CLEAR'] and current-group()/job[@type = 'COMPLETE']">
                <xsl:text>ok</xsl:text>
              </xsl:when>
              <xsl:when test="current-group()/job[@type = 'START'] and current-group()/job[@type = 'COMPLETE']">
                <xsl:text>ok</xsl:text>
              </xsl:when>
              <xsl:when test="current-group()/job[lower-case(@type) = 'warn']">warning</xsl:when>
              <xsl:when test="current-group()/job[lower-case(@type) = 'fail']">error</xsl:when>
              <xsl:otherwise>info-circle</xsl:otherwise>
            </xsl:choose>
          </json:string>
          <json:string key="thread"><xsl:value-of select="$first/@thread"/></json:string>
          <json:string key="username"><xsl:value-of select="$first/@username"/></json:string>
          <json:string key="title"><xsl:value-of select="$first/@title"/></json:string>
          <xsl:if test="$first/@groupid"><json:number key="groupId"><xsl:value-of select="$first/@groupid"/></json:number></xsl:if>
          <xsl:if test="$first/@group"><json:string key="group"><xsl:value-of select="$first/@group"/></json:string></xsl:if>

          <xsl:choose>
            <xsl:when test="$first/job[@type = 'START'][@documents]">
              <json:string key="message">Started batch indexing</json:string>
            </xsl:when>
            <xsl:when test="$first/job[@type = 'COMPLETE'][@documents]">
              <json:string key="message">Completed batch indexing in <xsl:value-of select="$first/job/@indexing" />ms</json:string>
            </xsl:when>
            <xsl:when test="$first/job[@contentid = 'CLEAR'] and current-group()/job[@type = 'COMPLETE']">
              <json:string key="message">Successfully cleared the index</json:string>
            </xsl:when>
            <xsl:when test="current-group()/job[@type = 'START'] and current-group()/job[@type = 'COMPLETE']">
              <json:string key="message">Successfully indexed <xsl:value-of select="f:index-job-title($first)"/>
                <xsl:if test="count($events[job/@contentid = $first/job/@contentid][job/@type = 'START']) gt 1">
                  <xsl:text> in group </xsl:text>
                  <xsl:value-of select="@group"/>
                </xsl:if> in <xsl:value-of select="current-group()[last()]/@timestamp - $first/@timestamp"/>ms</json:string>
              <xsl:sequence select="f:index-job-item($first/job)"/>
            </xsl:when>
            <xsl:when test="current-group()/job[@type = 'START'] and current-group()/job[@type = 'FAIL']">
              <json:string key="message">Unable to index <xsl:value-of select="f:index-job-title($first)"/></json:string>
              <xsl:sequence select="f:index-job-item($first/job)"/>
            </xsl:when>
            <xsl:otherwise>
              <json:string key="message"><xsl:value-of select="lower-case(job/@type)"/> [<xsl:value-of select="f:index-job-title($first)"/>]</json:string>
              <xsl:sequence select="f:index-job-item($first/job)"/>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:if test="current-group()[@level = 'WARN']">
            <json:array key="warnings">
              <xsl:for-each select="current-group()[@level = 'WARN']">
                <json:map><json:string key="warning"><xsl:value-of select="job"/></json:string></json:map>
              </xsl:for-each>
            </json:array>
          </xsl:if>
          <xsl:if test="current-group()/throwable">
            <json:array key="throwables">
              <xsl:apply-templates select="current-group()/throwable" mode="json" />
            </json:array>
          </xsl:if>
        </json:map>
      </xsl:for-each-group>
    </json:array>
  </json:map>
</xsl:template>

</xsl:stylesheet>
