<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-logs-access-ticket']" mode="json">
  <xsl:variable name="ticket-id" select="//parameter[@name='ticket']"/>
  <xsl:variable name="ticket" select="//ticket[@id=$ticket-id]"/>
  <json:map>
    <xsl:apply-templates select="$ticket" mode="json">
      <xsl:with-param name="key" select="'ticket'"/>
    </xsl:apply-templates>
    <xsl:if test="not($ticket)">
      <json:null key="ticket"/>
    </xsl:if>
    <xsl:if test="content/events/@more = 'true'"><json:boolean key="more">true</json:boolean></xsl:if>
    <json:array key="events">
      <xsl:variable name="first-event" select="//event[1]"/>
      <xsl:apply-templates select="//event" mode="json">
        <xsl:with-param name="first-event" select="$first-event"/>
      </xsl:apply-templates>
    </json:array>
  </json:map>
</xsl:template>

</xsl:stylesheet>
