<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-email-config']" mode="json">
  <json:map>
    <xsl:for-each select="content/email">
      <json:string key="project"><xsl:value-of select="@project"/></json:string>
      <xsl:for-each select="dkim">
        <json:map key="dkim">
          <json:string key="domain"><xsl:value-of select="@domain"/></json:string>
          <json:string key="selector"><xsl:value-of select="@selector"/></json:string>
          <json:boolean key="disabled"><xsl:value-of select="@disabled or false()"/></json:boolean>
        </json:map>
      </xsl:for-each>
      <xsl:for-each select="emails">
        <json:map key="emails">
          <json:string key="domain"><xsl:value-of select="@domain"/></json:string>
        </json:map>
      </xsl:for-each>
      <xsl:for-each select="sender">
        <json:map key="sender">
          <json:string key="name"><xsl:value-of select="@name"/></json:string>
          <json:string key="email"><xsl:value-of select="@email"/></json:string>
        </json:map>
      </xsl:for-each>
      <!-- TODO Does not include all possible values -->
    </xsl:for-each>
  </json:map>
</xsl:template>

</xsl:stylesheet>
