<?xml version="1.0"?>
<!--
  Project files templates
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="xs f">

<!-- Blank XSLT template -->
<xsl:template name="new-file-xsl"><![CDATA[<?xml version="1.0"?>
<!--
  GENERATED TEMPLATES - ENTER COMMENT HERE.

  @see https://www.w3.org/TR/xslt20/
]]>
  @author <xsl:value-of select="/root/content/session/member/fullname"/>
  @version <xsl:value-of select="format-date(current-date(), '[D] [MNn] [Y]')"/>
<![CDATA[-->
<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- modify element -->
  <xsl:template match="[my element]">
    <xsl:copy>
      <xsl:copy-of select="@*[not(name()='[my attribute]')]"/>
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template>

  <!-- copy all other elements unchanged -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
]]>
</xsl:template>

<!-- Blank XSLT Email template -->
<xsl:template name="new-file-xsl-email"><![CDATA[<?xml version="1.0"?>
<!--
  Email template
]]>
  @author <xsl:value-of select="/root/content/session/member/fullname"/>
  @version <xsl:value-of select="format-date(current-date(), '[D] [MNn] [Y]')"/>
<![CDATA[-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<!-- Main template -->
<xsl:template match="/notification">
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>[Email Title]</title>
  </head>
  <body>
    [Email content]
  </body>
</html>
</xsl:template>

</xsl:stylesheet>
]]>
</xsl:template>

<!-- Blank XSLT Text Email template -->
<xsl:template name="new-file-xsl-email-text"><![CDATA[<?xml version="1.0"?>
<!--
  Email template
]]>
  @author <xsl:value-of select="/root/content/session/member/fullname"/>
  @version <xsl:value-of select="format-date(current-date(), '[D] [MNn] [Y]')"/>
<![CDATA[-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<!-- Main template -->
<xsl:template match="/notification">
[Email text content]
</xsl:template>

</xsl:stylesheet>
]]>
</xsl:template>

<!-- Blank JavaScript template -->
<xsl:template name="new-file-js">
/**
* GENERATED SCRIPT - ENTER COMMENT HERE.
*
* @see https://developer.mozilla.org/en/JavaScript/Reference
*
* @author <xsl:value-of select="/root/content/session/member/fullname"/>
* @version <xsl:value-of select="format-date(current-date(), '[D] [MNn] [Y]')"/>
*/

// Enter code here...

</xsl:template>

<!-- New publication config -->
<xsl:template name="new-file-publication-config"><![CDATA[<?xml version="1.0"?>
<!--
  The * indicates the default value if the attribute is omitted.

  <toc> attributes:
    - title-collapse="[always*|auto|never]": specifies when document title headings should be collapsed
      (i.e. removed from the TOC) to avoid duplication with the parent link in the TOC. Allowed values are:
        always: if the first heading in a document is a higher level than the other headings always collapse it;
        auto: if the first heading in a document is a higher level than the other headings and it matches the document title then collapse it;
        never: never collapse headings.
    - para-indents: A comma separated list of indent values for numbered or prefixed paras which will be included
        in the TOC (only the first 40 characters of the content will appear in the TOC).
    - block-labels: A comma separated list of block labels, that if wrapping numbered or prefixed paras,
        will include them in the TOC.

  <levels> attributes:
    - xref-relative-to="[heading*|document]": indicates what xref level is relative to
        heading: relative to previous heading (default)
        document: relative to containing document
    - para-relative-to="[heading*|document|5|6|7|8|9]": indicates what para level is relative to
        heading: relative to previous heading (default)
        document: relative to containing document

  <numbering> attributes:
    - skipped-levels="[1*|0|strip]": numbering of skipped levels (only "1" is supported by docx)
        1: skipped levels will be numbered as 1 - e.g. 2.1.3 (default)
        0: skipped levels will be numbered as 0 - e.g. 2.0.3
        strip: skipped levels will be stripped - e.g. 2.3
    - document-label: numbering will only apply to documents with this label

  <scheme> attributes:
    - level: numbering level
    - type="[decimal*|upperalpha|loweralpha|upperroman|lowerroman]: numbering type
    - format: each level format is defined by the picture [x(level)x] where:
        - (level) is a digit which defines the level of numbering. Currently levels 1 to 9 are supported by PageSeeder.
        - x is any other content.
        The same level can only be repeated if it has a different block-label defined.
    - element="[heading*|para|any]": numbering only applied to this PSML element ("any" is not supported by docx)
    - block-label: separate numbering stream for this block label (format may require adjustment to match docx e.g. [Fig 1-][2])

  <restart> attributes:
    - level: numbering level
    - block-label: only restart numbering stream for this block label
 -->
<publication-config>
  <toc title-collapse="always" />

  <levels xref-relative-to="heading"
      para-relative-to="6" />

  <numbering skipped-levels="strip">
    <schemes>
      <scheme level="1" type="decimal"    format="[1]" />
      <scheme level="2" type="decimal"    format="[1.][2]" />
      <scheme level="3" type="decimal"    format="[1.][2.][3]" />
      <scheme level="4" type="decimal"    format="[1.][2.][3.][4]" />
      <scheme level="5" type="decimal"    format="[1.][2.][3.][4.][5]" />
      <scheme level="6" type="decimal"    format="[1.][2.][3.][4.][5.][6]" />
      <scheme level="7" type="loweralpha" format="[(7)]" element="para" />
      <scheme level="8" type="lowerroman" format="[(8)]" element="para" />
      <scheme level="9" type="upperalpha" format="[(9)]" element="para" />
      <scheme level="10" type="upperroman" format="[(10)]" element="para" />
    </schemes>
  </numbering>

  <!--
  <numbering skipped-levels="strip" document-label="autonumber1">
    <schemes>
      <scheme level="1" type="decimal"    format="[1.]" />
      <scheme level="2" type="decimal"    format="[1.][2.]" />
      <scheme level="3" type="decimal"    format="[1.][2.][3.]"     element="any"/>
      <scheme level="4" type="decimal"    format="[1.][2.][3.][4.]" element="any"/>
      <scheme level="5" type="loweralpha" format="[(5)]"            element="para"/>
      <scheme level="6" type="lowerroman" format="[(6)]"            element="para" />
      <scheme level="7" type="upperalpha" format="[(7)]" />
      <scheme level="7" type="decimal"    format="[Table 1-][7]"    block-label="table-caption" />
      <scheme level="7" type="upperalpha" format="[Fig 1-][7]"      block-label="figure-caption" />
      <scheme level="8" type="upperroman" format="[(8)]" />
      <scheme level="9" type="loweralpha" format="[9]" />
    </schemes>
    <restarts>
      <restart level="3" block-label="table-caption" />
    </restarts>
  </numbering>
  -->

</publication-config>
]]>
</xsl:template>

<!-- New document config (PSML) -->
<xsl:template name="new-file-psml-documentconfig">
  <xsl:param name="config" /><![CDATA[<?xml version="1.0"?>
<!--
  The document configuration is used by PageSeeder to define:
  - how documents of this are created
  - the editing options
  - the labeling options
  - the role options
  - the publishing options
-->
<document-config>

  <!--
    Define how documents are created.

    All the options below are optional.

    - @disable           = 'true' to prevent this document type from being created via
                           the user interface.
    - <title>            = The title of this document type in the user interface
    - <description>      = Description of this document type for display in the user
                           interface.
    - <folder>           = Constraints on where documents of this type can be created
        @context         = Defines a path where the document can be created.
                           When the actual context folder does not match this value,
                           the document type cannot be selected. The path may contain wildcards (*)
                           and may be absolute (starting with /) within the group or relative (starting with a character).
                           Relative context will use a matching folder anywhere in the current location.
                           Default has no value meaning "any folder"
        @path            = Defines the path relative to the context folder where the
                           documents will be created (Dynamic).
    - <filename>         = Constraints on the name of the file
        @value           = How the filename is constructed (Dynamic).
        @transform       = A comma separated list of transformations that need to be
                           applied in order to the value of the filename.
                           Possible transformations are: 'charfolding', 'trim',
                           'underscore', 'hyphen', 'lowercase', 'uppercase'
    - <document>         = Document properties
        @title           = Title for the document (Dynamic).
        @docid           = Document ID (Dynamic).
        @publicationid   = Publication ID (Dynamic).
        @publicationtype = Publication Type (default to 'default').
        @labels          = Comma separated list of labels

    Values marked as 'Dynamic' may contain dynamic elements such as autonumbers
    and date parts. They are specified as tokens between curly brackets '{}'.
    Possible tokens are:
      Y (year), M (month), D (day of month), W (week of year)
      N (autonumber), Px (autonumber divided by x)
    They can be formatted using leading zeros to use padding or repeat the
    letter to use an exact number of digits.
    Examples: "{YYYY}-{MM}-{DD}", "{0000N}", "Week #{W}"
  -->
  <creation>
    <title>]]><xsl:value-of select="$config"/><![CDATA[</title>
    <description></description>
  </creation>

  <!--
    Editing options in use for this type of document.

    Each <editor> can define:
    - @fragmenttype  = to bind a specific fragment type to a different editor (optional)
    - <options>      = options to be sent along as to services for the editor
        @editnote    = the edit note options 'optional', 'prompt', 'required' (default 'optional')
  -->
  <editing>
    <!--
    <editor fragmenttype="mytype">
      <options editnote="required"/>
    </editor>
    -->
  </editing>

  <!--
    Labels for this document type.

    Each <labels> can define:
    - @type           = The type of label to define
                      (content-block, content-inline, image, link, xref, edit-note, fragment, document)
    - <label>         = A label for the type
       @name          = the name of the label
       @description   = A description for this label
       @fragmenttypes = A comma separated list of fragment types to restrict label to
  -->
  <labeling>
    <!--
    <labels type="[content-block|content-inline|image|link|xref|edit-note|fragment|document]">
      <label name="[name]" description="[description]" [fragmenttypes=""]/>
    </labels>
    -->
  </labeling>

  <!--
    Roles can be defined below.

    Each <role> should include a
    - @type        = the element the role applies to - preformat|table|col|row|cell|hcell|list|nlist
    - @name        = the role name
    - @description = a description for the role (optional)

  -->
  <roles>
    <!--
    <role type="cell" name="indent-1" description="Indentation level 1" />
    <role type="cell" name="indent-2" description="Indentation level 2" />
    <role type="cell" name="indent-3" description="Indentation level 3" />

    <role type="table" name="presentation" description="Table used for presentation" />
    <role type="table" name="data" description="Table containing data" />
    -->
  </roles>

  <!--
    Publishing actions can be defined below.

    Each <action> should include a
    - @type         = the type of action - export|publish|process
    - <target>      = each target in the ANT script the user can run
       @name        = the name of the target
       @perspective = only display target in this perspective (optional)
       @role        = role required to see this target - contributor|manager|approver (optional)

    Each <target> should include a
    - <description> = a description of this action for the user interface
    - <param>       = each parameter the user can specify
       @type        = the type of value - text|date|number|checkbox|select
       @label       = the label for the user interface
       (see documentation for more optional attributes/elements)
  -->
  <publishing>
    <!--
    <action type="export">
      <target name="psml-to-pdf-columns" perspective="developer">
        <description>Export as PDF in 3 columns</description>
      </target>
    </action>

    <action type="publish">
      <target name="psml-to-website">
        <description>Publish to website</description>
        <param name="depth" label="Depth of XRefs to publish" type="number" min="1" max="8" />
      </target>
    </action>
    -->
  </publishing>

</document-config>
]]>
</xsl:template>

<!-- New URL config (PSML) -->
<xsl:template name="new-file-psml-urlconfig">
<xsl:param name="config" /><![CDATA[<?xml version="1.0"?>
<!--
  The URL configuration is used by PageSeeder to define:
  - how URLs of this type are created
  - the editing options
  - the publishing options
-->
<url-config>

  <!--
    Define how URLs are created.

    All the options below are optional.

    - @disable      = 'true' to prevent this URL type from being created via
                      the user interface.
    - <title>       = The title of this URL type in the user interface
    - <description> = Description of this URL type for display in the user
                      interface.
    - <domain>      = Constraints on the domain of the URL (can be multiple)
        @name       = The name of the allowed host.
    - <media>       = Constraints on the media type of the URL (can be multiple)
        @type       = The media type of the allowed host.

  -->
  <creation>
    <title>]]><xsl:value-of select="concat(upper-case(substring($config,1,1)),substring($config, 2))"/><![CDATA[</title>
    <description></description>
  </creation>

  <!--
    Labels for this URL type.

    Each <labels> can define:
    - @type           = Must be set to "url"
    - <label>         = A label for the type
       @name          = the name of the label
       @description   = A description for this label
       @fragmenttypes = A comma separated list of fragment types to restrict label to
  -->
  <labeling>
    <!--
    <labels type="url">
      <label name="[name]" description="[description]" [fragmenttypes=""]/>
    </labels>
    -->
  </labeling>

  <!--
    Publishing actions can be defined below.

    Each <action> should include a
    - @type         = the type of action - export|publish|process
    - <target>      = each target in the ANT script the user can run
       @name        = the name of the target
       @perspective = only display target in this perspective (optional)
       @role        = role required to see this target - contributor|manager|approver (optional)

    Each <target> should include a
    - <description> = a description of this action for the user interface
    - <param>       = each parameter the user can specify
       @type        = the type of value - text|date|number|checkbox|select
       @label       = the label for the user interface
       (see documentation for more optional attributes/elements)
  -->
  <publishing>
    <!--
    <action type="export">
      <target name="url-metadata-pdf" perspective="developer">
        <description>Export metadata as PDF</description>
      </target>
    </action>
    -->
  </publishing>

</url-config>
]]>
</xsl:template>

<!-- New document template (URL) -->
<xsl:template name="new-file-psml-urltemplate">
<xsl:param name="config" />
<![CDATA[<!--
URL template for ]]><xsl:value-of select="$config"/><![CDATA[

URL templates are generally used to define metadata for URLs.
-->
<document type="]]><xsl:value-of select="$config"/><![CDATA[" level="metadata" xmlns:t="http://pageseeder.com/psml/template">

<!--
<metadata>
  <properties>
    <property name="type" title="Type" value="{$meta.og:type}" />
  </properties>
</metadata>
-->

</document>
]]>
</xsl:template>

<!-- New document template (PSML) -->
<xsl:template name="new-file-psml-documenttemplate">
  <xsl:param name="config" /><![CDATA[<!--
  PSML document template for ]]><xsl:value-of select="$config"/><![CDATA[

  The document template is in PSML format but also includes basic templating elements
  to allow a fill-in-the-blanks instantiation of a new document.

  When creating new documents, PageSeeder will send the following parameters:
   - ps.title           = The title from the user interface or as specified by the <creation> options.
   - ps.filename        = The filename of the document
   - ps.description     = The the description entered in the user interface
   - ps.author          = The first name and surname of the user creating the document
   - ps.docid           = The document ID from the user interface or as specified by the <creation> options.
   - ps.group           = The current group for the document
   - ps.path            = The path of the document
   - ps.currentdate     = The current date in ISO8601 format
   - ps.currentdatetime = The current datetime in ISO8601 format including timezone information
   - ps.currenttime     = The current time in ISO8601 format including timezone information

  Parameters can be defined using
    <t:param name="[name]" title="[title for UI]" default="[default value if unspecified or empty]"
      type="[text|integer|date|datetime|xml]" />

  Parameter values can be inserted using:
    <t:value name="[name]"/> inside text nodes
    {$[name]} inside attribute nodes

  Fragments can be defined at the top using:
    <t:fragment type="[fragment type]" title="[title for UI]">
      <t:description>[fragment type description]</t:description>

  Fragments can be inserted inside <section> using:
    <t:fragment-ref id="[fragment id]" type="[fragment type]" />
-->
<document type="]]><xsl:value-of select="$config"/><![CDATA[" level="portable" xmlns:t="http://pageseeder.com/psml/template">

  <!-- Fragment types -->
  <!--
  <t:fragment type="mytype" title="My Type">
    <t:description>Use for my content.</t:description>
    <fragment>
      <para>My type's content.</para>
    </fragment>
  </t:fragment>
  -->

  <!-- Metadata properties -->
  <!--
  <metadata>
    <properties>
      <property name="template_version" title="Template version" value="1" />
      <property name="order-date"       title="Order date"       value="" datatype="date" />
    </properties>
  </metadata>
  -->

  <!-- Title -->
  <section id="title">
    <fragment id="1">
      <heading level="1"><t:value name="ps.title"/></heading>
    </fragment>
  </section>

  <!-- Sample section including default content -->
  <!--
  <section id="content">
    <fragment id="2">
      <para><t:value name="ps.description"/></para>
    </fragment>
  </section>
  -->

  <!-- Sample section incuding properties fragment -->
  <!--
  <section id="details">
    <properties-fragment id="3">
      <property name="title"   title="Title"     value="{$ps.title}" />
      <property name="pubdate" title="Published" value="{$ps.currentdate}" datatype="date" />
    </properties-fragment>
  </section>
  -->

  <!-- Sample section including xref fragment -->
  <!--
  <section id="xrefs">
    <xref-fragment id="4"/>
  </section>
  -->

  <!-- Sample section including media fragment with mathml -->
  <!--
  <section id="media">
    <media-fragment id="5" mediatype="application/mathml+xml" />
  </section>
  -->

</document>
]]>
</xsl:template>

<!-- New document template (binary media) -->
<xsl:template name="new-file-psml-mediatemplate">
  <xsl:param name="config" /><![CDATA[<!--
  PSML media template for ]]><xsl:value-of select="$config"/><![CDATA[

  Media templates are generally used to define metadata for binary documents.

  @see https://dev.pageseeder.com/get_started/tutorials/substitute_lo-res_with_hi-res_images.html
-->
<document level="metadata" xmlns:t="http://pageseeder.com/psml/template">

  <!--
  <metadata>
    <properties>
      <property name="caption" title="Caption"   value="" />
      <property name="hi-res"  title="Hi-res"    datatype="xref" />
    </properties>
  </metadata>
  -->

</document>
]]>
</xsl:template>

<!-- New publish config -->
<xsl:template name="new-file-psml-publishconfig"><![CDATA[<?xml version="1.0"?>
<!--
  The publish config allows you to customize the ANT scripts that can be run
  by the publish engine. Using <publishing override="true"> will replace all
  default actions with these otherwise they are added.

  Each <action> should include:
  - @type         = the type of action - export|publish|process|upload|upload-preview
  - <source>      = what source object this action applies to
     @type        = the type of source - group|folder|document
     @extension   = the filename extension of the source (required for type document)
  - <target>      = each target in the ANT script the user can run
     @name        = the name of the target
     @perspective = only display target in this perspective (optional)
     @role        = role required to see this target - contributor|manager|approver (optional)

  Each <target> should include:
  - <description> = a description of this action for the user interface
  - <param>       = each parameter the user can specify
     @name        = the name of the parameter
     @label       = the label for the user interface
     @type        = the type of value - text|date|number|checkbox|select (optional)
     (see help for more optional attributes/elements)
  -->
<publishing>
  <!--
  <action type="export">
    <source type="document" extension="psml" />
    <target name="psml-to-pdf-columns" perspective="developer">
      <description>Export as PDF in 3 columns</description>
    </target>
  </action>

  <action type="publish">
    <source type="folder" />
    <target name="psml-to-website">
      <description>Publish to website</description>
      <param name="xref-depth" label="Depth of XRefs to publish" type="number" min="1" max="8" />
    </target>
  </action>
  -->
</publishing>
]]>
</xsl:template>

<!-- New schedule config -->
<xsl:template name="new-file-psml-scheduleconfig"><![CDATA[<?xml version="1.0"?>
<!--
  The schedule config allows you to schedule ANT scripts to run
  on the publish engine.

  Each <event> should include:
  - <start>       = details about starting the script
     @datetime    = the date/time the script should first be run (ISO 8601 format)
  - <repeat>      = details about repeating the script (only one of days/hours/minutes is allows)
     @days        = the number of days between script runs
     @hours       = the number of hours between script runs
     @minutes     = the number of minutes between script runs
     @daysofweek  = restricts the script to run on the days listed (optional - requires repeat of 1 day or less).
     @until       = the date/time after which the script should not run (ISO 8601 format)
  - <target>      = each target in the ANT script the user can run
     @name        = the name of the target

  Each <target> should include:
  - <description> = a description of this event for the user interface
  - <param>       = each parameter supplied to the script (optional)
     @name        = the name of the parameter
     @value       = the value of the parameter
  -->
<schedule>
  <!--
  <event>
    <start datetime="2010-07-15T07:00:00+10:00" />
    <repeat minutes="4" until="2010-07-15T10:00:00+10:00" />
    <target name="create-comment">
      <description>Create Comments</description>
      <param name="folder-name" value="tutorials" />
      <param name="max-size" value="10" />
    </target>
  </event>
  <event>
    <start datetime="2010-07-14T00:00:00+10:00" />
    <repeat days="1" daysofweek="mon,tue,wed,thu,fri"
        until="2010-08-14T00:00:00+10:00" />
    <target name="generate-summary" >
      <description>Produce Daily Summary</description>
    </target>
  </event>
  -->
</schedule>
]]>
</xsl:template>

<!-- New organization config -->
<xsl:template name="new-file-organizationconfig"><![CDATA[<?xml version="1.0"?>
<organization-config>

  <email>
    <!-- example:
    <dkim domain="example.org" selector="mymail" />
    <emails domain="example.org" />
    <sender name="My app" email="myapp@example.org" />
    <links prefix="http://example.org/email" />
    <images prefix="http://example.org/images/email" logo-filename="email-logo.png" />
    <application name="My app" homepage="http://example.org" helppage="http://example.org/help"/>
    <footer text="My company pty. ltd., 123 My address, NSW 2000, Australia" />
    -->
    <style>
      <!-- example:
      <text font-family="'Helvetica Neue', 'Droid Sans', Helvetica, sans-serif" />
      <header background-color="#f7f7f7" text-color="#1179D2"/>
      <banner type="security"
              background-color="#f7f7f7" text-color="#1179D2"/>
      <banner type="moderation"
              background-color="#f7f7f7" text-color="#1179D2"/>
      <footer background-color="#f7f7f7" text-color="#999"/>
      -->
    </style>
  </email>

  <ui>
    <!-- example:
    <style theme="blue"/>
    <images icon-filename="ui-icon.svg" logo-filename="ui-logo.svg" />
    <legal>
      <document name="terms" title="Terms of use" agree-on="all" />
      <document name="privacy" title="Privacy policy" agree-on="signup" />
      <document name="cookies" title="Cookie policy" agree-on="login" />
      <document name="copyright" title="Copyright policy" />
    </legal>
    -->
  </ui>

  <security>
    <!-- example:
    <login groups="example-editors,example-config" projects="config" />
    <token type="activate-member" expiration="P2DT12H" />
    <token type="remember-me" expiration="P30DT1H" />
    <members>
      <email domain="example.org" />
      <email domain="example.net" />
    </members>
    -->
  </security>

</organization-config>]]>
</xsl:template>

<!-- New xref config -->
<xsl:template name="new-file-xrefconfig"><![CDATA[<?xml version="1.0"?>
<xref-configs>
  <!--
  <xref-config name="config-name" title="Config title">
    <xref display="[document|document+manual|document+fragment|manual|template]"
          frag="[fragment ID or default]"
          labels="[comma-separated list of mandatory labels]"
          optionallabels="[comma-separated list of optional labels]"
          title="[title for manual and template display]"
          type="[none|transclude|embed|alternate|math]"
          level="[0-5] - 0 means no level"
          reverselink="[true|false] - default true"
          reversetitle="[title for reverse link]" />
    <target documenttype="[PSML document type]"
            folder="[relative to group or starting / means absolute or
                    starting . or .. means relative to current document
                    and may also have * for any path segment]"
            filters="[comma-separated list of filters]"
            new="[none|create|edit] - default create"
            group="[full group name to search in]"
            this="[true|false]" />
    <autosuggest questionfields="[comma-separated list of fields]"
                 displayfields="[comma-separated list of fields]" />
  </xref-config>
  -->
</xref-configs>]]>
</xsl:template>

<!-- New editor config -->
<xsl:template name="new-file-editorconfig"><![CDATA[<?xml version="1.0"?>
<editor-configs>
  <!--
  <editor-config name="PSMLProperties">
    <field name="category" type="select" label="Category">
      <value>English</value>
      <value>History</value>
      <value>Maths</value>
      <value>Science</value>
    </field>
    <field name="in-stock" type="select" label="In Stock">
      <value>Yes</value>
      <value>No</value>
    </field>
    <field name="available-date" type="date" label="Available Date" />
    <field name="isbn13"         type="text" label="ISBN"      placeholder="Enter a valid ISBN 13 number (97xxxxxxxxxxx)" pattern="97[89][0-9]{10}" />
    <field name="publisher"      type="xref" label="Publisher" placeholder="Lookup XRef"/>
  </editor-config>
   -->
  <!--
  <editor-config name="PSMLMetadata">
    <field name="width"  type="text" label="Width"  pattern="[0-9]" />
    <field name="height" type="text" label="Height" pattern="[0-9]" />
    <field name="hi-res" type="xref" label="Hi-res">
      <xref-config>
        <target filters="pstype:document,pssubtype:image" />
      </xref-config>
    </field>
    <field name="action" type="select" label="Action">
      <value>None</value>
      <value>Zoom</value>
      <value>Fullscreen</value>
    </field>
  </editor-config>
   -->
  <!--
  <editor-config name="PSMLCreation">
    <field name="category" type="select" label="Category">
      <value>English</value>
      <value>History</value>
      <value>Maths</value>
      <value>Science</value>
    </field>
    <field name="in-stock" type="select" label="In Stock">
      <value>Yes</value>
      <value>No</value>
    </field>
    <field name="available-date" type="date" label="Available Date" />
    <field name="isbn13"         type="text" label="ISBN"      placeholder="Enter a valid ISBN 13 number (97xxxxxxxxxxx)" pattern="97[89][0-9]{10}" />
    <field name="publisher"      type="xref" label="Publisher" placeholder="Lookup XRef"/>
  </editor-config>
   -->
  <!--
  <editor-config name="PSMLXRefs">
    <xref-config>
      <xref type="embed" />
      <target documenttype="book"
              folder="documents/*"
              filters="pslabel:new,psstatus:Approved" />
      <autosuggest questionfields="pstitle,psdocid,pdfilename"
                   displayfields="psdocid,pslabel" />
    </xref-config>
  </editor-config>
   -->
</editor-configs>]]>
</xsl:template>

<!-- New editor config -->
<xsl:template name="new-file-editorconfig-url"><![CDATA[<?xml version="1.0"?>
<editor-configs>
  <!--
  <editor-config name="PSMLMetadata">
    <field name="author"  type="text" label="Author" />
    <field name="type" type="select" label="Type">
      <value>Article</value>
      <value>Interview</value>
      <value>Report</value>
      <value>Opinion</value>
    </field>
  </editor-config>
   -->
</editor-configs>]]>
</xsl:template>

<!-- Blank CSS template -->
<xsl:template name="new-file-css">
/**
 * GENERATED STYLES - ENTER COMMENT HERE.
 *
 * @author <xsl:value-of select="/root/content/session/member/fullname"/>
 * @version <xsl:value-of select="format-date(current-date(), '[D] [MNn] [Y]')"/>
 */

</xsl:template>

<!-- Blank CSS template -->
<xsl:template name="new-file-psml-css">
  <xsl:param name="config" select="'[config]'"/>
/**
 * GENERATED STYLES - ENTER COMMENT HERE.
 *
 * @author <xsl:value-of select="/root/content/session/member/fullname"/>
 * @version <xsl:value-of select="format-date(current-date(), '[D] [MNn] [Y]')"/>
 */

/* Specific styles should be prefixed by '.psml-content' */
.document-type-<xsl:value-of select="$config"/> .psml-content  { }

</xsl:template>

<xsl:template name="new-file-member-details"><![CDATA[<?xml version="1.0"?>
<!--
  If <member-details shared="true"> the details can be shared between groups.

  Each field for the member details is defined with a `<field>` element.

  Field attributes:

  - position: position of the field - an integer between 1 and 15 (required).
  - name: A name for the field - letters and numbers only (required).
  - title: A user-friendly name to display adjacent the form fields or as a header for tables.
  - visibility: who is allowed see the value - one of "group", "member" or "manager" (default "manager").
  - editable: whether the member can edit the field via the user interface - "true" or "false" (default "false")
  - type: type of input in the user interface - "text" or "date" (default "text").
-->
<member-details>
  <!--
  <field position="1" name="org"   title="Organization" editable="true" visibility="group" type="text" />
  -->
</member-details>]]>
</xsl:template>

<!--
  A new schematron document.
-->
<xsl:template name="new-file-psml-schematron">
  <xsl:param name="config" select="'config'"/><![CDATA[<?xml version="1.0"?>
<!--
  This schematron validates a PSML document.

  The schematron rules can be used to enforce additional constraints required
  by the application.

  @see https://dev.pageseeder.com/psml.html
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:title>Rules for ]]><xsl:value-of select="$config"/><![CDATA[ documents</sch:title>

  <!-- BELOW ARE EXAMPLES ONLY WHICH SHOULD BE MODIFIED FOR YOUR DOCUMENTS -->

  <!--
    Set of rules applying to the entire document
  -->
  <sch:pattern>
    <sch:title>Document</sch:title>

    <sch:rule context="/document">

      <!-- Too many sections -->
      <sch:assert test="count(section) le 20">Your document contains over 20
      sections. You should consider splitting your document into multiple
      documents.</sch:assert>

      <!-- No Doc ID -->
      <sch:report test="not(documentinfo/uri/@docid)">Your document
      does not have a Doc ID.</sch:report>

      <!-- No Label -->
      <sch:report test="not(documentinfo/uri/@labels)">Your document
      has no label.</sch:report>

    </sch:rule>

  </sch:pattern>

  <!--
    Set of rules applying to the document fragments
  -->
  <sch:pattern>
    <sch:title>Fragments</sch:title>

    <sch:rule context="section/fragment">

      <!-- Fragment has no heading -->
      <sch:assert test="name(*[1]) = 'heading'"
                  properties="fragment">Fragment
      '<sch:value-of select="@id"/>' has no title.</sch:assert>

      <!-- Fragment is too long (over 2000 chars)-->
      <sch:assert test="string-length(string-join(.//text(), '')) le 2000"
                  properties="fragment">
      Fragment '<sch:value-of select="@id"/>' has over 2000 characters.
      </sch:assert>

    </sch:rule>

  </sch:pattern>

  <sch:properties>

    <!-- To help identify the fragment when using `properties="fragment"` -->
    <sch:property id="fragment"><sch:value-of select="ancestor-or-self::fragment/@id"/></sch:property>

  </sch:properties>

</sch:schema>
]]>
</xsl:template>

  <!--
  A new schematron document.
-->
<xsl:template name="new-file-properties-schematron">
  <xsl:text><![CDATA[<?xml version="1.0"?>
<!--
  This schematron defines properties used in Schematron rules
-->
<sch:properties xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <!-- To help identify the fragment when using `properties="fragment"` -->
  <sch:property id="fragment"><sch:value-of select="ancestor-or-self::fragment/@id"/></sch:property>

</sch:properties>
]]></xsl:text>
</xsl:template>

<!--
  A new schematron document (media).
-->
<xsl:template name="new-file-psml-schematron-media">
  <xsl:param name="config" select="'config'"/><![CDATA[<?xml version="1.0"?>
<!--
  This schematron validates the PSML for a media document.

  Schematron rules for media are generally used to enforce constraints on metadata.

  @see https://dev.pageseeder.com/psml.html
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:title>Rules for ]]><xsl:value-of select="$config"/><![CDATA[ documents</sch:title>

  <!-- BELOW ARE EXAMPLES ONLY WHICH SHOULD BE MODIFIED FOR YOUR DOCUMENTS -->

  <!--
    Set of rules applying to the entire document
  -->
  <sch:pattern>
    <sch:title>Document</sch:title>

    <sch:rule context="/document">

      <!-- Must have hi-res alternative -->
      <sch:assert test="metadata//property[@name='hi-res']/xref[@type='alternate'] or
                        .//reversexref[@forwardtype='alternate']">
        No hi-res alternative defined.</sch:assert>

      <!-- Must have caption -->
      <sch:assert test="normalize-space(metadata//property[@name='caption']/@value) != ''">
        No caption defined.</sch:assert>

    </sch:rule>

  </sch:pattern>

</sch:schema>
]]>
</xsl:template>

<!--
  A new schematron document (url).
-->
<xsl:template name="new-file-psml-schematron-url">
<xsl:param name="config" select="'config'"/><![CDATA[<?xml version="1.0"?>
<!--
  This schematron validates the PSML for a URL.

  Schematron rules for URLs are generally used to enforce constraints on metadata.

  @see https://dev.pageseeder.com/psml.html
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:title>Rules for ]]><xsl:value-of select="$config"/><![CDATA[ URLs</sch:title>

  <!-- BELOW ARE EXAMPLES ONLY WHICH SHOULD BE MODIFIED FOR YOUR DOCUMENTS -->

  <!--
    Set of rules applying to the entire document
  -->
  <sch:pattern>
    <sch:title>Document</sch:title>

    <sch:rule context="/document">

      <!-- Must have a type -->
      <sch:assert test="normalize-space(metadata//property[@name='type']/@value) != ''">
        No type defined.</sch:assert>

      <!-- Must have an author -->
      <sch:assert test="normalize-space(metadata//property[@name='author']/@value) != ''">
        No author defined.</sch:assert>

    </sch:rule>

  </sch:pattern>

</sch:schema>
]]>
</xsl:template>

<!-- A new word import config -->
<xsl:template name="new-word-import-config"><![CDATA[<?xml version="1.0"?>
<!-- This configuration transforms DocX into PSML -->
<config version="1.1.0">

  <lists>
    <convert-to-list-roles select="false"/>
    <!-- generate numbered attribute to paragraphs for lists -->
    <convert-to-numbered-paragraphs select="false">
      <level value="1" output="prefix"/>
      <!-- prefix or numbering or inline=[label] or text -->
      <level value="2" output="prefix"/>
      <level value="3" output="prefix"/>
      <level value="4" output="prefix"/>
      <level value="5" output="prefix"/>
      <level value="6" output="prefix"/>
    </convert-to-numbered-paragraphs>
    <!-- generate numbered paragraphs for document titles -->

    <!-- adds an inline label around the true number of each numbered paragraph ( in the future will be set to prefix...) -->
    <convert-manual-numbering select="false" />
  </lists>

  <!-- =======================STYLE PROPERTIES======================= -->

  <!-- Values accepted: name of style available in word file -->
  <styles>
    <ignore>
      <wordstyle value="TOC1" />
      <wordstyle value="TOC2" />
      <wordstyle value="TOC3" />
      <wordstyle value="TOC4" />
      <wordstyle value="TOC5" />
      <wordstyle value="TOC6" />
      <wordstyle value="TOC7" />
      <wordstyle value="TOC8" />
      <wordstyle value="TOC9" />
    </ignore>
    <default>
      <paragraphStyles value="block" />
      <!-- possible values: 'para' or 'block' -->
      <characterStyles value="inline" />
      <!-- possible values: 'none' or 'inline' -->
      <smart-tag keep="true" />
      <references psmlelement="link" /> <!-- required when using PSML split config -->
      <!--  <property name="prefix" value="true" /> possible values: 'false' or 'true' -->
    </default>

    <!-- Values accepted: name of style available in word file -->
    <wordstyle name="Title" psmlelement="heading">
      <level value="1" />
    </wordstyle>

    <wordstyle name="Subtitle" psmlelement="heading">
      <level value="3" />
    </wordstyle>

    <wordstyle name="Heading1" psmlelement="heading">
      <level value="1" />
      <!-- <numbering select="true" value="numbering" /> -->
    </wordstyle>

    <wordstyle name="Heading2" psmlelement="heading">
      <level value="2" />
    </wordstyle>

    <wordstyle name="Heading3" psmlelement="heading">
      <level value="3" />
    </wordstyle>

    <wordstyle name="Heading4" psmlelement="heading">
      <level value="4" />
    </wordstyle>

    <wordstyle name="Heading5" psmlelement="heading">
      <level value="5" />
    </wordstyle>

    <wordstyle name="Heading6" psmlelement="heading">
      <level value="6" />
    </wordstyle>

    <wordstyle name="HeadingUnnum1" psmlelement="heading">
      <level value="1" />
    </wordstyle>

    <wordstyle name="HeadingUnnum2" psmlelement="heading">
      <level value="2" />
    </wordstyle>

    <wordstyle name="HeadingUnnum3" psmlelement="heading">
      <level value="3" />
    </wordstyle>

    <wordstyle name="HeadingUnnum4" psmlelement="heading">
      <level value="4" />
    </wordstyle>

    <wordstyle name="HeadingUnnum5" psmlelement="heading">
      <level value="5" />
    </wordstyle>

    <wordstyle name="HeadingUnnum6" psmlelement="heading">
      <level value="6" />
    </wordstyle>

    <wordstyle name="HTMLCode" psmlelement="monospace"/>

    <wordstyle name="Emphasis" psmlelement="italic"/>

    <wordstyle name="Strong" psmlelement="bold"/>

    <wordstyle name="HTMLPreformatted" psmlelement="preformat"/>

    <wordstyle name="BodyText" psmlelement="para"/>

    <wordstyle name="PSTableHeader" psmlelement="para"/>

    <wordstyle name="PSTableBody" psmlelement="para"/>

    <wordstyle name="FootnoteText" psmlelement="para" />

    <wordstyle name="EndnoteText" psmlelement="para" />
  </styles>

</config>]]>
</xsl:template>

<!-- A new PSML split config -->
<xsl:template name="new-psml-split-config"><![CDATA[<?xml version="1.0"?>
<split-config version="0.7.0">
  <container />
  <document folder="components">
    <heading level="1"/>
    <heading level="2"/>
  </document>
  <fragment>
    <heading level="3"/>
    <heading level="4"/>
  </fragment>
</split-config>]]>
</xsl:template>


<!-- A new word export config -->
<xsl:template name="new-word-export-config"><![CDATA[<?xml version="1.0"?>
<!-- This configuration transforms PSML into DOCX,
     see PageSeeder Help for details -->
<config version="6.2002">

  <!-- The <core> element can populate the document properties in the
       exported Word file from content in the PSML document -->
  <core>
    <creator select="[ps-current-user]" />
    <description select="[ps-document-description]" />
    <title select="[ps-document-title]" />
    <!-- <modified select="[ps-document-modified]" /> -->
    <created select="[ps-current-date]" />
    <keywords select="[ps-document-labels]" />
    <subject select="" />
    <category select="" />
    <version select="1.0" />
    <revision select="1" />
  </core>

  <!-- The <toc> (Table Of Contents) element customizes the TOC
       in the exported Word file -->
  <toc generate="true">
    <outline generate="true" select="1-9" /> <!-- range from 1 up to 9-->
    <paragraph generate="false">
      <!-- any paragraph style defined in the document with the corresponding TOC indent level  -->
      <!-- <style value="[word style]" indent="[indent level]" /> -->
    </paragraph>
  </toc>

  <!-- The <default> element sets defaults for the export -->
  <default>
    <defaultparagraphstyle wordstyle="Body Text" />
    <defaultcharacterstyle wordstyle="Default Paragraph Font" />
    <comments generate="false" />
    <endnotes documenttype="endnotes" />
    <footnotes documenttype="footnotes" />
    <xrefs hyperlinkstyle="PS Hyperlink" referencestyle="PS Reference"/>
    <placeholders unresolvedstyle="PS Unresolved" />
  </default>

  <!-- The <elements> map PSML elements to Word styles and features based on PSML document labels.
       The default DOCX export automatically adds the 'references' label for the 'references' document type -->
  <elements label="references">
    <document wordsection="1" />
    <heading>
      <level value="1" wordstyle="Title" />
      <level value="2" wordstyle="TOC Heading" />
      <level value="3" wordstyle="Subtitle" />
      <level value="4" wordstyle="Subtitle 2" />
    </heading>
  </elements>

  <!-- To enable page numbers on front matter
       transclude another document which has document label "front" -->
  <elements label="front">
    <document wordsection="2" />
    <heading>
      <level value="2" wordstyle="TOC Heading" />
      <level value="3" wordstyle="Front Matter 1" />
      <level value="4" wordstyle="Front Matter 2" />
    </heading>
  </elements>

  <!-- To insert a landscape page
       transclude another document which has document label "landscape" -->
  <elements label="landscape">
    <document wordsection="4" />
  </elements>

  <elements>
    <document wordsection="3" />
    <!-- default options:"generate-ps-style|none" -->
    <!-- label options:"generate-ps-style|[name of style]" -->
    <block default="generate-ps-style">
      <!-- <label value="mylabel" wordstyle="My Paragraph Style" /> -->
    </block>

    <!-- default options:"generate-ps-style|none" -->
    <!-- label options:"generate-ps-style|[name of style]" -->
    <inline default="generate-ps-style">
      <!-- <label value="mylabel" wordstyle="My Character Style" /> -->
    </inline>

    <properties-fragments>
      <properties-fragment tablestyle="Properties Table"
                           titlestyle="Properties Table Header"
                           valuestyle="Properties Table Body" >
        <width type="pct" value="60%"/>
      </properties-fragment>
    </properties-fragments>

    <tables>
      <table default="PS Table"
             headstyle="PS Table Header"
             bodystyle="PS Table Body"
             bodyliststyle="Table Bulleted List"
             bodynliststyle="Table Numbered List">
        <width type="pct" value="5000"/>
      </table>
    </tables>

    <!-- NOTE: wordstyle "heading [x]" only must be in lower case -->
    <heading>
      <!-- Unnumbered headings -->
      <level value="1" wordstyle="Heading Unnum 1"/>
      <level value="2" wordstyle="Heading Unnum 2"/>
      <level value="3" wordstyle="Heading Unnum 3"/>
      <level value="4" wordstyle="Heading Unnum 4"/>
      <level value="5" wordstyle="Heading Unnum 5"/>
      <level value="6" wordstyle="Heading Unnum 6"/>
      <level value="7" wordstyle="Heading Unnum 7"/>
      <level value="8" wordstyle="Heading Unnum 8"/>
      <level value="9" wordstyle="Heading Unnum 9"/>
      <!-- Unnumbered prefixed headings -->
      <level value="1" prefixed="true" wordstyle="Heading Unnum 1"/>
      <level value="2" prefixed="true" wordstyle="Heading Unnum 2"/>
      <level value="3" prefixed="true" wordstyle="Heading Unnum 3"/>
      <level value="4" prefixed="true" wordstyle="Heading Unnum 4"/>
      <level value="5" prefixed="true" wordstyle="Heading Unnum 5"/>
      <level value="6" prefixed="true" wordstyle="Heading Unnum 6"/>
      <level value="7" prefixed="true" wordstyle="Heading Unnum 7"/>
      <level value="8" prefixed="true" wordstyle="Heading Unnum 8"/>
      <level value="9" prefixed="true" wordstyle="Heading Unnum 9"/>
      <!-- Numbered headings -->
      <level value="1" numbered="true" wordstyle="heading 1"/>
      <level value="2" numbered="true" wordstyle="heading 2"/>
      <level value="3" numbered="true" wordstyle="heading 3"/>
      <level value="4" numbered="true" wordstyle="heading 4"/>
      <level value="5" numbered="true" wordstyle="heading 5"/>
      <level value="6" numbered="true" wordstyle="heading 6"/>
      <level value="7" numbered="true" wordstyle="heading 7"/>
      <level value="8" numbered="true" wordstyle="heading 8"/>
      <level value="9" numbered="true" wordstyle="heading 9"/>
      <!-- Numbered prefixed headings -->
      <level value="1" numbered="true" prefixed="true" wordstyle="heading 1">
        <prefix select="false" />
      </level>
      <level value="2" numbered="true" prefixed="true" wordstyle="heading 2">
        <prefix select="false" />
      </level>
      <level value="3" numbered="true" prefixed="true" wordstyle="heading 3">
        <prefix select="false" />
      </level>
      <level value="4" numbered="true" prefixed="true" wordstyle="heading 4">
        <prefix select="false" />
      </level>
      <level value="5" numbered="true" prefixed="true" wordstyle="heading 5">
        <prefix select="false" />
      </level>
      <level value="6" numbered="true" prefixed="true" wordstyle="heading 6">
        <prefix select="false" />
      </level>
      <level value="7" numbered="true" prefixed="true" wordstyle="heading 7">
        <prefix select="false" />
      </level>
      <level value="8" numbered="true" prefixed="true" wordstyle="heading 8">
        <prefix select="false" />
      </level>
      <level value="9" numbered="true" prefixed="true" wordstyle="heading 9">
        <prefix select="false" />
      </level>
    </heading>

    <para>
      <indent level="0" wordstyle="Body Text"/>
      <!-- Indented unnumbered paragraphs -->
      <indent level="1" wordstyle="List Continue"/>
      <indent level="2" wordstyle="List Continue 2"/>
      <indent level="3" wordstyle="List Continue 3"/>
      <indent level="4" wordstyle="List Continue 4"/>
      <indent level="5" wordstyle="List Continue 5"/>
      <indent level="6" wordstyle="List Continue 6"/>
      <indent level="7" wordstyle="List Continue 7"/>
      <indent level="8" wordstyle="List Continue 8"/>
      <indent level="9" wordstyle="List Continue 9"/>
      <!-- Prefixed paragraphs -->
      <indent level="1" prefixed="true" wordstyle="List Manual"/>
      <indent level="2" prefixed="true" wordstyle="List Manual 2"/>
      <indent level="3" prefixed="true" wordstyle="List Manual 3"/>
      <indent level="4" prefixed="true" wordstyle="List Manual 4"/>
      <indent level="5" prefixed="true" wordstyle="List Manual 5"/>
      <indent level="6" prefixed="true" wordstyle="List Manual 6"/>
      <indent level="7" prefixed="true" wordstyle="List Manual 7"/>
      <indent level="8" prefixed="true" wordstyle="List Manual 8"/>
      <indent level="9" prefixed="true" wordstyle="List Manual 9"/>
      <!-- Numbered paragraphs -->
      <indent level="1" numbered="true" wordstyle="Para Indent"/>
      <indent level="2" numbered="true" wordstyle="Para Indent 2"/>
      <indent level="3" numbered="true" wordstyle="Para Indent 3"/>
      <indent level="4" numbered="true" wordstyle="Para Indent 4"/>
      <indent level="5" numbered="true" wordstyle="Para Indent 5"/>
      <indent level="6" numbered="true" wordstyle="Para Indent 6"/>
      <indent level="7" numbered="true" wordstyle="Para Indent 7"/>
      <indent level="8" numbered="true" wordstyle="Para Indent 8"/>
      <indent level="9" numbered="true" wordstyle="Para Indent 9"/>
      <!-- Numbered prefixed paragraphs -->
      <indent level="1" numbered="true" prefixed="true" wordstyle="Para Indent">
        <prefix select="false" />
      </indent>
      <indent level="2" numbered="true" prefixed="true" wordstyle="Para Indent 2">
        <prefix select="false" />
      </indent>
      <indent level="3" numbered="true" prefixed="true" wordstyle="Para Indent 3">
        <prefix select="false" />
      </indent>
      <indent level="4" numbered="true" prefixed="true" wordstyle="Para Indent 4">
        <prefix select="false" />
      </indent>
      <indent level="5" numbered="true" prefixed="true" wordstyle="Para Indent 5">
        <prefix select="false" />
      </indent>
      <indent level="6" numbered="true" prefixed="true" wordstyle="Para Indent 6">
        <prefix select="false" />
      </indent>
      <indent level="7" numbered="true" prefixed="true" wordstyle="Para Indent 7">
        <prefix select="false" />
      </indent>
      <indent level="8" numbered="true" prefixed="true" wordstyle="Para Indent 8">
        <prefix select="false" />
      </indent>
      <indent level="9" numbered="true" prefixed="true" wordstyle="Para Indent 9">
        <prefix select="false" />
      </indent>
    </para>

    <preformat wordstyle="HTML Preformatted"/>

    <nlist liststyle="Numbered List">
      <!-- <role value="[value of role]" liststyle="[word list style]" /> -->
    </nlist>

    <list liststyle="Bulleted List">
      <!-- <role value="[value of role]" liststyle="[word list style]" /> -->
    </list>

    <listpara>
      <level value="1" wordstyle="List Continue" />
      <level value="2" wordstyle="List Continue 2" />
      <level value="3" wordstyle="List Continue 3" />
      <level value="4" wordstyle="List Continue 4" />
      <level value="5" wordstyle="List Continue 5" />
      <level value="6" wordstyle="List Continue 6" />
      <level value="7" wordstyle="List Continue 7" />
      <level value="8" wordstyle="List Continue 8" />
      <level value="9" wordstyle="List Continue 9" />
    </listpara>

    <image wordstyle="Image" />

  </elements>
</config>]]>
</xsl:template>

<!-- A new pdf export config -->
<xsl:template name="new-pdf-export-config"><![CDATA[<?xml version="1.0"?>
<config>
  <styles>
    <!-- =======================GENERAL PROPERTIES======================= -->
    <page>
      <property name="page-height"            value="29.7cm"/>
      <property name="page-width"             value="21cm"/>
      <property name="margin-top"             value="1.5cm"/>
      <property name="margin-bottom"          value="1.5cm"/>
      <property name="margin-left"            value="2.5cm"/>
      <property name="margin-right"           value="2.5cm"/>
    </page>
    <body>
      <region-property name="margin-top"      value="1cm"/>
      <region-property name="margin-bottom"   value="1cm"/>
      <!-- ZapfDingbats is for tick/check mark -->
      <property name="font-family"            value="NotoSans,NotoSansMath,NotoEmoji,sans-serif,ZapfDingbats"/>
      <property name="font-size"              value="11pt"/>
      <property name="font-weight"            value="normal"/>
      <property name="line-height"            value="150%"/>
      <property name="color"                  value="#000000"/>
    </body>
    <header first="true">
      <region-property name="extent"          value="1cm" />
      <property name="font-size"              value="10pt"/>
      <property name="line-height"            value="12pt"/>
      <property name="border-bottom-style"    value="solid"/>
      <property name="border-bottom-width"    value="0"/>
      <left><filename /></left>
      <right><date pattern="[D1o] [MNn], [Y]" /></right>
    </header>
    <header>
      <region-property name="extent"          value="1cm" />
      <property name="font-size"              value="10pt"/>
      <property name="line-height"            value="12pt"/>
      <property name="padding-bottom"         value="0.5cm"/>
      <property name="border-bottom-style"    value="solid"/>
      <property name="border-bottom-width"    value="0"/>
      <left><filename /></left>
      <right><date pattern="[D1o] [MNn], [Y]" /></right>
    </header>
    <footer first="true">
      <region-property name="extent"          value="1cm" />
      <property name="font-size"              value="10pt"/>
      <property name="padding-top"    	      value="0.5cm"/>
      <property name="border-top-style"       value="solid"/>
      <property name="border-top-width"       value="1pt"/>
      <property name="border-top-color"       value="#efefef"/>
      <center>
        <text>Page </text><page-number/><text> of </text><total-pages/>
      </center>
    </footer>
    <footer>
      <region-property name="extent"          value="1cm" />
      <property name="font-size"              value="10pt"/>
      <property name="padding-top"    	      value="0.5cm"/>
      <property name="border-top-style"       value="solid"/>
      <property name="border-top-width"       value="1pt"/>
      <property name="border-top-color"       value="#efefef"/>
      <center>
        <text>Page </text><page-number/><text> of </text><total-pages/>
      </center>
    </footer>

    <!-- =======================ELEMENTS PROPERTIES======================= -->

    <element name="heading" level="1">
      <property name="font-size"              value="20pt"/>
      <property name="font-weight"            value="normal"/>
      <property name="line-height"            value="130%"/>
      <property name="color"                  value="#014d84"/>
      <property name="margin-top"             value="21pt"/>
      <property name="margin-bottom"          value="9pt"/>
      <property name="page-break-after"       value="avoid"/>
      <property name="keep-with-next"         value="always"/>
    </element>

    <element name="heading" level="2">
      <property name="font-size"              value="16pt"/>
      <property name="font-weight"            value="normal"/>
      <property name="line-height"            value="130%"/>
      <property name="color"                  value="#002c4b"/>
      <property name="margin-top"             value="18pt"/>
      <property name="margin-bottom"          value="9pt"/>
      <property name="page-break-after"       value="avoid"/>
      <property name="keep-with-next"         value="always"/>
    </element>

    <element name="heading" level="3">
      <property name="font-size"              value="14pt"/>
      <property name="font-weight"            value="normal"/>
      <property name="line-height"            value="130%"/>
      <property name="color"                  value="#434343"/>
      <property name="margin-top"             value="15pt"/>
      <property name="margin-bottom"          value="6pt"/>
      <property name="page-break-after"       value="avoid"/>
      <property name="keep-with-next"         value="always"/>
    </element>

    <element name="heading" level="4">
      <property name="font-size"              value="12pt"/>
      <property name="font-weight"            value="normal"/>
      <property name="line-height"            value="130%"/>
      <property name="color"                  value="#666666"/>
      <property name="margin-top"   value="13pt"/>
      <property name="margin-bottom"    value="6pt"/>
      <property name="page-break-after"       value="avoid"/>
      <property name="keep-with-next"         value="always"/>
    </element>

    <element name="heading" level="5">
      <property name="font-size"              value="11pt"/>
      <property name="font-weight"            value="normal"/>
      <property name="line-height"            value="130%"/>
      <property name="color"                  value="#666666"/>
      <property name="margin-top"   value="12pt"/>
      <property name="margin-bottom"    value="6pt"/>
      <property name="page-break-after"       value="avoid"/>
      <property name="keep-with-next"         value="always"/>
    </element>

    <element name="heading" level="6">
      <property name="font-size"              value="11pt"/>
      <property name="font-weight"            value="normal"/>
      <property name="line-height"            value="130%"/>
      <property name="font-style"             value="italic"/>
      <property name="color"                  value="#666666"/>
      <property name="margin-top"   value="12pt"/>
      <property name="margin-bottom"    value="6pt"/>
      <property name="page-break-after"       value="avoid"/>
      <property name="keep-with-next"         value="always"/>
    </element>

    <element name="heading-prefix" level="1">
      <property name="start-indent" value="-2cm"/>
      <property name="text-indent"  value="2cm"/>
      <property name="margin-right" value="0.1cm"/>
      <property name="color"        value="#0077ee"/>
    </element>

    <element name="heading-prefix" level="2">
      <property name="start-indent" value="-2cm"/>
      <property name="text-indent"  value="2cm"/>
      <property name="margin-right" value="0.1cm"/>
      <property name="color"        value="#0077ee"/>
    </element>

    <element name="heading-prefix" level="3">
      <property name="start-indent" value="-2cm"/>
      <property name="text-indent"  value="2cm"/>
      <property name="margin-right" value="0.1cm"/>
      <property name="color"        value="#0077ee"/>
    </element>

    <element name="heading-prefix" level="4">
      <property name="start-indent" value="-2cm"/>
      <property name="text-indent"  value="2cm"/>
      <property name="margin-right" value="0.1cm"/>
      <property name="color"        value="#0077ee"/>
    </element>

    <element name="heading-prefix" level="5">
      <property name="start-indent" value="-2cm"/>
      <property name="text-indent"  value="2cm"/>
      <property name="margin-right" value="0.1cm"/>
      <property name="color"        value="#0077ee"/>
    </element>

    <element name="heading-prefix" level="6">
      <property name="start-indent" value="-2cm"/>
      <property name="text-indent"  value="2cm"/>
      <property name="margin-right" value="0.1cm"/>
      <property name="color"        value="#0077ee"/>
    </element>

    <element name="para">
      <property name="margin-top"             value="0pt"/>
      <property name="margin-bottom"          value="18pt"/>
      <property name="text-align"             value="left"/>
      <property name="hyphenate"              value="false"/>
      <property name="orphans"                value="3"/>
      <property name="widows"                 value="2"/>
    </element>

    <element name="para" level="1">
      <property name="start-indent"           value="1cm"/>
    </element>

    <element name="para" level="2">
      <property name="start-indent"           value="2cm"/>
    </element>

    <element name="para" level="3">
      <property name="start-indent"           value="3cm"/>
    </element>

    <element name="para" level="4">
      <property name="start-indent"           value="4cm"/>
    </element>

    <element name="para" level="5">
      <property name="start-indent"           value="5cm"/>
    </element>

    <element name="para" level="6">
      <property name="start-indent"           value="6cm"/>
    </element>

    <element name="para-prefix">
      <property name="start-indent"           value="-2cm"/>
      <property name="text-indent"            value="2cm"/>
      <property name="margin-right"           value="0.1cm"/>
      <property name="text-align"             value="right"/>
    </element>

    <element name="para-prefix" level="1">
      <property name="start-indent"           value="-2cm"/>
      <property name="text-indent"            value="3cm"/>
      <property name="margin-right"           value="0.1cm"/>
      <property name="text-align"             value="right"/>
    </element>

    <element name="para-prefix" level="2">
      <property name="start-indent"           value="-2cm"/>
      <property name="text-indent"            value="4cm"/>
      <property name="margin-right"           value="0.1cm"/>
      <property name="text-align"             value="right"/>
    </element>

    <element name="para-prefix" level="3">
      <property name="start-indent"           value="-2cm"/>
      <property name="text-indent"            value="5cm"/>
      <property name="margin-right"           value="0.1cm"/>
      <property name="text-align"             value="right"/>
    </element>

    <element name="para-prefix" level="4">
      <property name="start-indent"           value="-2cm"/>
      <property name="text-indent"            value="6cm"/>
      <property name="margin-right"           value="0.1cm"/>
      <property name="text-align"             value="right"/>
    </element>

    <element name="para-prefix" level="5">
      <property name="start-indent"           value="-2cm"/>
      <property name="text-indent"            value="7cm"/>
      <property name="margin-right"           value="0.1cm"/>
      <property name="text-align"             value="right"/>
    </element>

    <element name="para-prefix" level="6">
      <property name="start-indent"           value="-2cm"/>
      <property name="text-indent"            value="8cm"/>
      <property name="margin-right"           value="0.1cm"/>
      <property name="text-align"             value="right"/>
    </element>

    <element name="section-title">
      <property name="font-size"              value="24pt"/>
      <property name="font-weight"            value="normal"/>
      <property name="line-height"            value="130%"/>
      <property name="color"                  value="#014d84"/>
      <property name="margin-top"             value="21pt"/>
      <property name="margin-bottom"          value="9pt"/>
      <property name="page-break-after"       value="avoid"/>
      <property name="keep-with-next"         value="always"/>
    </element>

    <element name="toc">
      <property name="break-before"           value="page"/>
      <property name="break-after"            value="page"/>
    </element>

    <element name="table">
      <property name="margin-top"   value="5pt"/>
      <property name="margin-bottom"    value="24pt"/>
      <property name="margin-top"             value="5pt"/>
      <property name="margin-bottom"          value="24pt"/>
      <property name="border-collapse"        value="collapse"/>
      <property name="border-top-color"       value="#efefef"/>
      <property name="border-top-style"       value="solid"/>
      <property name="border-top-width"       value="0pt"/>
    </element>

    <element name="table-hcell">
      <property name="display-align"         value="center"/>
      <property name="background-color"       value="#efefef"/>
      <property name="padding"                value="0.1cm"/>

      <property name="border-before-color"    value="transparent"/>
      <property name="border-before-style"    value="solid"/>
      <property name="border-before-width"    value="0"/>

      <property name="border-after-color"     value="transparent"/>
      <property name="border-after-style"     value="solid"/>
      <property name="border-after-width"     value="0"/>

      <property name="border-start-color"     value="transparent"/>
      <property name="border-start-style"     value="solid"/>
      <property name="border-start-width"     value="0"/>

      <property name="border-end-color"       value="transparent"/>
      <property name="border-end-style"       value="solid"/>
      <property name="border-end-width"       value="0"/>

      <property name="border-top-color"       value="#d5d5d5"/>
      <property name="border-top-style"       value="solid"/>
      <property name="border-top-width"       value="1pt"/>

      <property name="border-bottom-color"    value="#d5d5d5"/>
      <property name="border-bottom-style"    value="solid"/>
      <property name="border-bottom-width"    value="1pt"/>
    </element>

    <element name="table-cell">
      <property name="display-align"          value="center"/>
      <property name="background-color"       value="#FFFFFF"/>
      <property name="padding"                value="0.1cm"/>

      <property name="border-before-color"    value="transparent"/>
      <property name="border-before-style"    value="solid"/>
      <property name="border-before-width"    value="0"/>

      <property name="border-after-color"     value="transparent"/>
      <property name="border-after-style"     value="solid"/>
      <property name="border-after-width"     value="0"/>

      <property name="border-start-color"     value="transparent"/>
      <property name="border-start-style"     value="solid"/>
      <property name="border-start-width"     value="0"/>

      <property name="border-end-color"       value="transparent"/>
      <property name="border-end-style"       value="solid"/>
      <property name="border-end-width"       value="0"/>

      <property name="border-top-color"       value="#d5d5d5"/>
      <property name="border-top-style"       value="solid"/>
      <property name="border-top-width"       value="1pt"/>

      <property name="border-bottom-color"    value="#d5d5d5"/>
      <property name="border-bottom-style"    value="solid"/>
      <property name="border-bottom-width"    value="1pt"/>
    </element>

    <element name="hcell">
      <property name="display-align"          value="center"/>
      <property name="color"                  value="#000000"/>
      <property name="font-weight"            value="bold"/>
      <property name="font-size"              value="10pt"/>
      <property name="hyphenate"              value="false"/>
      <property name="language"               value="en"/>
      <property name="hyphenation-remain-character-count" value="5"/>
    </element>

    <element name="cell">
      <property name="display-align"          value="center"/>
      <property name="color"                  value="#000000"/>
      <property name="font-weight"            value="normal"/>
      <property name="font-size"              value="10pt"/>
      <property name="hyphenate"              value="false"/>
      <property name="language"               value="en"/>
      <property name="hyphenation-remain-character-count" value="5"/>
    </element>

    <element name="property-title">
      <property name="font-weight"  value="bold"/>
      <property name="text-align"   value="start"/>
      <property name="margin-left"  value="0.08cm" />
      <property name="space-before" value="0.08cm" />
      <property name="margin-right" value="0.08cm" />
    </element>

    <element name="property-title-cell">
      <property name="width"                  value="5cm" />
      <property name="border-style"           value="solid"/>
      <property name="border-color"           value="#d5d5d5"/>
      <property name="border-width"           value="1pt 0"/>
      <property name="background-color"       value="#efefef"/>
      <property name="color"                  value="#000000"/>
      <property name="font-weight"            value="bold"/>
      <property name="font-size"              value="10pt"/>
      <property name="hyphenate"              value="false"/>
      <property name="language"               value="en"/>
      <property name="padding"                value="4pt 2pt"/>
      <property name="hyphenation-remain-character-count" value="5"/>
    </element>

    <element name="property-value">
      <property name="text-align"   value="start"/>
      <property name="margin-left"  value="0.08cm" />
      <property name="space-before" value="0.08cm" />
      <property name="margin-right" value="0.08cm" />
    </element>

    <element name="property-value-cell">
      <property name="border-style"           value="solid"/>
      <property name="border-color"           value="#d5d5d5"/>
      <property name="border-width"           value="1pt 0"/>
      <property name="background-color"       value="#FFFFFF"/>
      <property name="color"                  value="#000000"/>
      <property name="font-weight"            value="normal"/>
      <property name="font-size"              value="10pt"/>
      <property name="hyphenate"              value="false"/>
      <property name="language"               value="en"/>
      <property name="padding"                value="4pt 2pt"/>
      <property name="hyphenation-remain-character-count" value="5"/>
    </element>

    <element name="block">
      <property name="text-align"             value="justify"/>
      <property name="hyphenate"              value="false"/>
      <property name="margin-top"   value="4pt"/>
      <property name="margin-bottom"    value="24pt"/>
      <property name="margin-left"            value="0"/>
      <property name="margin-right"           value="0"/>
      <property name="page-break-inside"      value="avoid"/>
      <property name="border-top-style"       value="solid"/>
      <property name="border-right-style"     value="solid"/>
      <property name="border-bottom-style"    value="solid"/>
      <property name="border-left-style"      value="solid"/>
      <property name="border-width"           value="1pt 1pt 1pt 4pt"/>
      <property name="border-color"           value="#CCCCCC"/>
      <property name="background-color"       value="transparent"/>
      <property name="padding"                value="0.6cm 0.5cm 0"/>
    </element>

    <!--  add custom style for specific block, change custom to suit your own style -->
    <element name="block-custom">
    </element>

    <element name="blockName">
      <property name="ps-hide"                value="true"/>
      <property name="text-align"             value="justify"/>
      <property name="hyphenate"              value="false"/>
      <property name="color"                  value="#777777"/>
      <property name="font-weight"            value="bold"/>
    </element>

    <!--  add custom style for specific blockName, change custom to suit your own style -->
    <element name="blockName-custom">
    </element>

    <element name="inline">
      <property name="hyphenate"              value="false"/>
      <property name="font-size"              value="11pt"/>
      <property name="font-weight"            value="normal"/>
      <property name="border-width"           value="0 0 2pt 0"/>
      <property name="border-style"           value="solid"/>
      <property name="border-color"           value="#9FB7C9"/>
      <property name="background-color"       value="transparent"/>
    </element>

    <!--  add custom style for specific inline, change custom to suit your own style -->
    <element name="inline-custom">
    </element>

    <element name="inlineName">
      <property name="ps-hide"                value="true"/>
      <property name="text-align"             value="justify"/>
      <property name="hyphenate"              value="false"/>
      <property name="font-size"              value="11.25pt"/>
      <property name="font-weight"            value="bold"/>
      <property name="color"                  value="#FFFFFF"/>
      <property name="border-width"           value="0 2pt"/>
      <property name="border-style"           value="solid"/>
      <property name="border-color"           value="#FF6699"/>
      <property name="background-color"       value="#FF6699"/>
    </element>

    <!--  add custom style for specific inlineName, change custom to suit your own style -->
    <element name="inlineName-custom">
    </element>

    <element name="preformat">
      <property name="margin-top"   value="5pt"/>
      <property name="margin-bottom"    value="20pt"/>
      <property name="font-size"              value="9pt"/>
      <property name="font-family"            value="Consolas,Liberation Mono,Courier,monospace,NotoSansMath,NotoEmoji,ZapfDingbats"/>
      <property name="color"                  value="#434343"/>
      <property name="white-space-collapse"   value="false"/>
      <property name="white-space-treatment"  value="preserve"/>
      <property name="linefeed-treatment"     value="preserve"/>
      <property name="page-break-inside"      value="avoid"/>
      <property name="border-style"           value="solid"/>
      <property name="border-width"           value="1px 1px 1px 3pt"/>
      <property name="border-color"           value="#CECECE"/>
      <property name="background-color"       value="transparent"/>
      <property name="margin-left"            value="0"/>
      <property name="margin-right"           value="0"/>

      <!--
      <property name="wrap-option"            value="true"/>
      <property name="text-indent"            value="3cm"/>
      -->
    </element>

    <element name="monospace">
      <property name="margin-top"             value="5pt"/>
      <property name="margin-bottom"          value="20pt"/>
      <property name="font-size"              value="9pt"/>
      <property name="font-family"            value="Consolas,Liberation Mono,Courier,monospace,NotoSansMath,NotoEmoji,ZapfDingbats"/>
      <property name="color"                  value="#434343"/>
      <property name="white-space-collapse"   value="false"/>
      <property name="white-space-treatment"  value="preserve"/>
      <property name="linefeed-treatment"     value="preserve"/>
      <property name="page-break-inside"      value="avoid"/>
      <property name="border-style"           value="solid"/>
      <property name="border-width"           value="1pt 2pt 2pt 2pt"/>
      <property name="border-color"           value="#CECECE"/>
      <property name="background-color"       value="transparent"/>
      <property name="margin-left"            value="0"/>
      <property name="margin-right"           value="0"/>
      <property name="padding"                value="1.5pt 3.75pt"/>
    </element>

    <element name="list">
      <property name="provisional-distance-between-starts"    value="0.4cm"/>
      <property name="provisional-label-separation"           value="0.2cm"/>
      <property name="margin-top"                   value="5pt"/>
      <property name="margin-bottom"                    value="20pt"/>
      <property name="page-break-inside"                      value="avoid"/>
    </element>

    <element name="nlist">
      <property name="provisional-distance-between-starts"    value="0.4cm"/>
      <property name="provisional-label-separation"           value="0.2cm"/>
      <property name="margin-top"                   value="2pt"/>
      <property name="margin-bottom"                    value="18pt"/>
    </element>

    <element name="list-item">
      <property name="margin-top"                   value="5pt"/>
      <property name="margin-bottom"                    value="8pt"/>
    </element>

    <element name="link">
      <property name="color"                  value="#016ebc"/>
      <property name="text-decoration"        value="underline"/>
      <property name="font-weight"            value="normal"/>
    </element>

    <element name="xref">
      <property name="color"                  value="#016ebc"/>
      <property name="text-decoration"        value="underline"/>
      <property name="font-weight"            value="normal"/>
    </element>

    <element name="xref" role="mathml">
      <property name="color"                  value="#000000"/>
      <property name="text-decoration"        value="none"/>
    </element>

    <element name="xref" role="asciimath">
      <property name="color"                  value="#000000"/>
      <property name="text-decoration"        value="none"/>
    </element>

    <element name="xref" role="tex">
      <property name="color"                  value="#000000"/>
      <property name="text-decoration"        value="none"/>
    </element>

    <element name="blockxref">
      <property name="margin-top"   value="4pt"/>
      <property name="margin-bottom"    value="8pt"/>
      <property name="text-align"             value="justify"/>
      <property name="hyphenate"              value="false"/>
      <property name="color"                  value="#016ebc"/>
      <property name="text-decoration"        value="underline"/>
      <property name="font-weight"            value="bold"/>
    </element>

    <element name="image">
      <property name="margin-bottom"    value="12pt"/>
      <property name="text-align"             value="center"/>
    </element>

    <element name="bold">
      <property name="font-weight"        value="bold"/>
    </element>

    <element name="italic">
      <property name="font-style"         value="italic"/>
    </element>

    <element name="underline">
      <property name="text-decoration"    value="underline"/>
    </element>

    <element name="sub">
      <property name="font-size"          value="6pt"/>
      <property name="vertical-align"     value="sub"/>
    </element>

    <element name="sup">
      <property name="font-size"          value="6pt"/>
      <property name="vertical-align"     value="super"/>
    </element>

    <element name="toc-level1">
      <property name="margin-left"        value="0.5cm"/>
      <property name="text-align-last"    value="justify"/>
    </element>

    <element name="toc-level2">
      <property name="margin-left"        value="1cm"/>
      <property name="text-align-last"    value="justify"/>
    </element>

    <element name="toc-level3">
      <property name="margin-left"        value="1.5cm"/>
      <property name="text-align-last"    value="justify"/>
    </element>

    <element name="toc-level4">
      <property name="margin-left"        value="2cm"/>
      <property name="text-align-last"    value="justify"/>
    </element>

    <element name="toc-level5">
      <property name="margin-left"        value="2.5cm"/>
      <property name="text-align-last"    value="justify"/>
    </element>

    <element name="toc-level6">
      <property name="margin-left"        value="3cm"/>
      <property name="text-align-last"    value="justify"/>
    </element>

  </styles>
</config>]]>
</xsl:template>

  <!-- A new ANT build file -->
<xsl:template name="new-build-file"
><![CDATA[<?xml version="1.0"?>
<project name="[insert script name]"
         xmlns:ps="antlib:com.pageseeder.publishapi.ant">

  <target name="[insert target name]" description="[insert target description]">

    <ps:config />

    <!-- insert ANT tasks here -->

  </target>

</project>]]>
  </xsl:template>

</xsl:stylesheet>
