<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<!-- Site prefix -->
<xsl:variable name="site-prefix" select="/root/header/path/@context"/>

<!--
  Generates a link to a job
-->
<xsl:function name="f:index-job-title">
  <xsl:param name="event" />
  <xsl:value-of select="if ($event/job/@contenttype = 'URL') then 'URL' else
                        if ($event/job/@contenttype = 'COMMENT') then 'comment/workflow' else
                        lower-case($event/job/@contenttype)"/>
  <xsl:text> with ID </xsl:text>
  <xsl:value-of select="$event/job/@contentid"/>
</xsl:function>

<!--
  Generates a link to a job
-->
<xsl:function name="f:index-job-item">
  <xsl:param name="job" />
  <xsl:if test="$job/@contentid castable as xs:int">
    <json:map key="item">
      <json:number key="id"><xsl:value-of select="$job/@contentid" /></json:number>
      <json:string key="type"><xsl:value-of select="lower-case($job/@contenttype)" /></json:string>
    </json:map>
  </xsl:if>
</xsl:function>

<!--
  Ensures that the specified message does not contain any sensitive data.

  @param string the message to tidy up
-->
<xsl:function name="f:safe-message" as="xs:string">
  <xsl:param name="string" />
  <xsl:value-of select="replace($string, '(\s)\S*[/\\]WEB-INF([/\\])', '$1&#x2026;$2')"/>
</xsl:function>

</xsl:stylesheet>
