<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='setup']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Setup')"/>
</xsl:template>

<xsl:template match="root[@service='setup']" mode="main-content">
<xsl:variable name="setup" select="content[@name='setup']/setup"/>
<xsl:variable name="setup-prefill">
  <json:map>
    <xsl:for-each select="$setup/*">
      <json:string key="{name()}"><xsl:value-of select="." /></json:string>
    </xsl:for-each>
  </json:map>
</xsl:variable>
<div class="main-content">
  <main-panel>
    <xsl:choose>
      <xsl:when test="$setup and not(string-length($setup/dburl) gt 0)">
        <setup-form v-bind:prefill="{json:xml-to-json($setup-prefill)}"/>
      </xsl:when>
      <xsl:otherwise>
        <centered-box wide="">
          <public-content class="text-center">
            <translucent-fieldset>
              <p>PageSeeder is already configured.</p>
              <p>Please go to the <a href="{$site-prefix}/ui/admin.html" title="System administration">System administration</a> to
                to modify the database, email or license settings.</p>
            </translucent-fieldset>
          </public-content>
        </centered-box>
      </xsl:otherwise>
    </xsl:choose>
  </main-panel>
</div>
</xsl:template>

</xsl:stylesheet>
