<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='folder-browse']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Documents')"/>
</xsl:template>

<xsl:template match="root[@service='folder-browse']" mode="main-content">
  <xsl:variable name="roots"><json:array><xsl:apply-templates select="content/groupfolders" mode="json"/></json:array></xsl:variable>
  <xsl:variable name="default-guri" select="content//groupfolder[ends-with(@path, concat(translate(//context/group/@name, '-', '/'), '/*'))]" />
  <xsl:variable name="port" select="if (($default-guri/@scheme = 'http'  and $default-guri/@port = '80') or
                                            ($default-guri/@scheme = 'https' and $default-guri/@port = '443')) then '' else concat(':', $default-guri/@port)" />
  <xsl:variable name="document-types"><json:array><xsl:apply-templates select="//document-types/document-type" mode="json" /></json:array></xsl:variable>

  <xsl:variable name="publish-actions"><json:array>
    <xsl:apply-templates select="content/publish-config/publishing/action/target" mode="json" />
  </json:array></xsl:variable>

  <folder-bar v-bind:roots="{f:xml-to-json($roots)}"
              v-bind:document-types="{f:xml-to-json($document-types)}" />
  <main class="main-content">
    <side-panel side="left" v-bind:width="400" open=""/>

    <main-panel>
      <folder-documents group-name="{//context/group/@name}"
                        url-base="{$default-guri/@scheme}://{$default-guri/@host}{$port}"
                        location="{header//parameter[@name = 'path']}"
                        v-bind:document-types="{f:xml-to-json($document-types)}"
                        v-bind:publish-actions="{f:xml-to-json($publish-actions)}"
                        v-bind:member-id="{//session/member/@id}" />
    </main-panel>
    <side-panel side="right"/>
  </main>
</xsl:template>

</xsl:stylesheet>
