<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='project-admin-dashboard']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Project dashboard')"/>
</xsl:template>

<xsl:template match="root[@service='project-admin-dashboard']" mode="main-content">
<div class="main-content">
  <xsl:variable name="project" select="//context/project"/>

  <main-panel>
    <h1 class="page-title">
      <svg-icon name="dashboard"/> Project dashboard of
      <em><xsl:value-of select="if ($project/@title) then $project/@title else $project/@name"/></em>
    </h1>

    <xsl:choose>
      <xsl:when test="starts-with($current-project, 'archive-')">
        <project-archived-admin-dashboard />
      </xsl:when>
      <xsl:otherwise>
        <project-admin-dashboard />
      </xsl:otherwise>
    </xsl:choose>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
