<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-admin-sharing']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Group sharing')"/>
</xsl:template>

<xsl:template match="root[@service='group-admin-sharing']" mode="main-content">
<div class="main-content">
  <xsl:variable name="group"><xsl:apply-templates select="content/context/group" mode="json" /></xsl:variable>
  <xsl:variable name="groupfolders">
    <json:array>
      <xsl:apply-templates select="content/groupfolders/groupfolder" mode="json" />
    </json:array>
  </xsl:variable>
  <main-panel>
    <h1 class="page-title">Group sharing options</h1>

    <group-admin-sharing v-bind:group="{f:xml-to-json($group)}"
                         v-bind:group-folders="{f:xml-to-json($groupfolders)}"/>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
