<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-admin-members']" mode="html-title" as="xs:string*">
  <xsl:sequence select="if ($context/group) then ('Group members') else ('Project members')"/>
</xsl:template>

<xsl:template match="root[@service='group-admin-members']" mode="main-content">
  <xsl:variable name="group" select="if ($context/group) then $context/group else $context/project"/>
  <xsl:variable name="is-admin-system" select="//permissions/@admin-system = 'true'"/>
  <div class="main-content">
    <main-panel full-width="">
      <h1 class="page-title"><svg-icon name="member-groups"/> Manage members of <xsl:value-of select="if ($context/group) then 'group' else 'project'"/><xsl:text> </xsl:text>
        <em><xsl:value-of select="if ($group/@title) then $group/@title else $group/@name"/></em></h1>
      <xsl:variable name="prefix" select="//parameter[@name='prefix']"/>
      <group-admin-members v-bind:group="{f:to-json($group)}" initial-prefix="{$prefix}">
        <xsl:if test="$is-admin-system"><xsl:attribute name="is-admin"/></xsl:if>
      </group-admin-members>
    </main-panel>
    <side-panel side="right"/>
  </div>
</xsl:template>

</xsl:stylesheet>
