<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-admin-dashboard']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Group dashboard')"/>
</xsl:template>

<xsl:template match="root[@service='group-admin-dashboard']" mode="main-content">
<div class="main-content">
  <xsl:variable name="group" select="content/context/group" />
  <xsl:variable name="group-json"><xsl:apply-templates select="$group" mode="json" /></xsl:variable>

  <main-panel>
    <h1 class="page-title"><svg-icon name="dashboard"/> Group dashboard of
      <em><xsl:value-of select="if ($group/@title) then $group/@title else $group/@name"/></em></h1>

    <xsl:choose>
      <xsl:when test="starts-with($group/@name, 'archive-')">
        <xsl:variable name="permissions" select="//session/permissions"/>
        <group-archived-admin-dashboard v-bind:group="{f:xml-to-json($group-json)}">
          <xsl:if test="$permissions/@delete-all-xlinks = 'true' and $permissions/@delete-uri = 'true'">
            <xsl:attribute name="delete-enabled" />
          </xsl:if>
        </group-archived-admin-dashboard>
      </xsl:when>
      <xsl:otherwise>
        <group-admin-dashboard v-bind:group="{f:xml-to-json($group-json)}"
                               current-index-version="{//constants/@index-version}" />
      </xsl:otherwise>
    </xsl:choose>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
