<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-templates']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Project templates')"/>
</xsl:template>

<xsl:template match="root[@service='admin-templates']" mode="main-content">
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="file-template"/> Project templates</h1>

    <xsl:variable name="global-template" select="//constants/@global-template"/>
    <admin-templates global-template="{$global-template}" v-bind:projects="{f:to-json-array(.//project)}" />
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
