<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-system']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('System information')"/>
</xsl:template>

<xsl:template match="root[@service='admin-system']" mode="main-content">
<div class="main-content">
  <main-panel>
    <xsl:call-template name="current-server-datetime"/>
    <h1 class="page-title"><svg-icon name="system-status"/> System information</h1>

    <tabs-container>
      <tabs-tab name="core" title="Disk space and memory" selected="">
        <div class="grid-x grid-margin-x">
          <div class="cell medium-6">
            <xsl:apply-templates select="content[@name='get-space-available-for-documents']" mode="admin-system"/>
          </div>
          <div class="cell medium-6">
            <xsl:apply-templates select="content[@name='get-runtime-info']" mode="admin-system"/>
          </div>
        </div>
      </tabs-tab>
      <tabs-tab name="stats" title="Generator statistics" >
        <section>
          <h2 class="section-title">Generator statistics</h2>
          <admin-statistics-table />
        </section>
      </tabs-tab>
      <tabs-tab name="threads" title="Threads">
        <xsl:apply-templates select="content[@name='list-threads']" mode="admin-system"/>
      </tabs-tab>
      <tabs-tab name="libraries" title="Environment and libraries">
        <xsl:apply-templates select="content[@name='about']" mode="admin-system"/>
      </tabs-tab>
    </tabs-container>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

<!--
  Display details about the runtime environment
-->
<xsl:template match="content[@name='get-space-available-for-documents']" mode="admin-system">
  <section>
    <xsl:variable name="free-mb"  select="disk-space/@usable  idiv 1000000" as="xs:integer"/>
    <xsl:variable name="total-mb" select="disk-space/@total idiv 1000000" as="xs:integer"/>
    <xsl:variable name="free-pct"  select="if ($total-mb = 0) then 0 else $free-mb idiv ($total-mb idiv 100)"   as="xs:integer"/>
    <h2 class="section-title">Disk space</h2>
    <table class="system-resource-table diskspace">
      <tbody>
        <tr>
          <td colspan="2" class="total"><abbr title="Total amount of disk space">Total</abbr>: <xsl:value-of select="f:format-byte-size(disk-space/@total)"/></td>
        </tr>
        <tr class="bar">
          <td class="used" width="{100 - $free-pct}%"><xsl:value-of select="f:format-byte-size((disk-space/@total - disk-space/@usable) cast as xs:integer)"/></td>
          <td class="free" width="{$free-pct}%"><xsl:value-of select="f:format-byte-size(disk-space/@usable)"/></td>
        </tr>
        <tr>
          <td><abbr title="Amount of used disk space">Used</abbr> (<xsl:value-of select="100 - $free-pct"/>%)</td>
          <td><abbr title="Amount of free disk space">Free</abbr> (<xsl:value-of select="$free-pct"/>%)</td>
        </tr>
      </tbody>
    </table>
    <p><b><xsl:value-of select="//runtime/@processors"/></b> processor(s) available.</p>
  </section>
</xsl:template>

<!--
  Display details about the runtime environment
-->
<xsl:template match="content[@name='get-runtime-info']" mode="admin-system">
  <xsl:for-each select="runtime/memory">
    <admin-runtime-memory v-bind:free="{@free}" v-bind:max="{@max}" v-bind:total="{@total}" />
  </xsl:for-each>
</xsl:template>

<!--
  Display details about the runtime environment
-->
<xsl:template match="content[@name='list-threads']" mode="admin-system">
  <section>
    <h2 class="section-title">Threads <!-- a href="#" title="refresh" id="refresh-threads">&#x27f3;</a> <span id="since-last-refresh"></span --></h2>
    <table is="vue:basic-table" zebra="" show-columns="" class="threads">
      <thead>
        <th>Name</th>
        <th>Origin</th>
        <th>Priority</th>
        <th>State</th>
        <th>Daemon</th>
        <!-- th>&#x394;</th -->
      </thead>
      <tbody>
        <xsl:for-each select="descendant::thread">
          <xsl:sort select="f:guess-thread-origin(@name, @group)"/>
          <xsl:sort select="@name"/>
          <tr>
            <td><span title="{@id}: {@name}"><xsl:value-of select="if (string-length(@name) gt 30) then concat(substring(@name, 1,30), '...') else @name"/></span></td>
            <td><xsl:value-of select="f:guess-thread-origin(@name, @group)"/></td>
            <td><xsl:value-of select="@priority"/></td>
            <td>
              <span title="{@state}">
                <xsl:choose>
                  <xsl:when test="@state = 'RUNNABLE'">
                    <svg-icon name="play" color="green"/>
                  </xsl:when>
                  <xsl:when test="@state = 'WAITING'">
                    <svg-icon name="pause" color="grey"/>
                  </xsl:when>
                  <xsl:when test="@state = 'TIMED_WAITING'">
                    <svg-icon name="clock" color="grey"/>
                  </xsl:when>
                  <xsl:when test="@state = 'BLOCKED'">
                    <svg-icon name="stop" color="red"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <svg-icon name="question-mark" color="grey"/>
                  </xsl:otherwise>
                </xsl:choose>
              </span>
            </td>
            <td><xsl:value-of select="@daemon"/></td>
            <!-- td data-cpu="{times/@cpu}" data-id="{@id}" class="delta">-</td -->
          </tr>
        </xsl:for-each>
      </tbody>
    </table>
  </section>
</xsl:template>

<!--
-->
<xsl:template match="content[@name='about']" mode="admin-system">
  <section>
    <h2 class="section-title">Environment</h2>
    <table is="vue:basic-table" light="" style="width: 50%">
      <tbody>
        <tr>
          <th>Server version name</th>
          <td><xsl:value-of select="about/server/@info"/></td>
        </tr>
        <tr>
          <th>OS name</th>
          <td><xsl:value-of select="about/os/@name"/></td>
        </tr>
        <tr>
          <th>OS version</th>
          <td><xsl:value-of select="about/os/@version"/></td>
        </tr>
        <tr>
          <th>Architecture</th>
          <td><xsl:value-of select="about/os/@arch"/></td>
        </tr>
        <tr>
          <th>JVM name</th>
          <td><xsl:value-of select="about/jvm/@name"/></td>
        </tr>
        <tr>
          <th>JVM version</th>
          <td><xsl:value-of select="about/jvm/@version"/></td>
        </tr>
        <tr>
          <th>JVM vendor</th>
          <td><xsl:value-of select="about/jvm/@vendor"/></td>
        </tr>
        <tr>
          <th>JVM info</th>
          <td><xsl:value-of select="about/jvm/@info"/></td>
        </tr>
<!--        <database tables-version="6.00"/>-->
      </tbody>
    </table>

    <h2 class="section-title">Libraries</h2>
    <table is="vue:basic-table" zebra="" show-columns="">
      <tbody>
        <xsl:for-each select="about/libraries/library">
          <xsl:sort select="." />
          <tr>
            <td class="name">
              <xsl:value-of select="." />
              <xsl:if test="@extension != 'jar'">&#160;<span class="extension"><xsl:value-of select="@extension" /></span></xsl:if>
            </td>
            <td class="version"><xsl:value-of select="@version" /></td>
          </tr>
        </xsl:for-each>
      </tbody>
    </table>
  </section>
</xsl:template>

<!--
  Guess the origin of a thread based on its name and group
  @param name  The name of the thread
  @param group The thread group
-->
<xsl:function name="f:guess-thread-origin" as="xs:string?">
  <xsl:param name="name"/>
  <xsl:param name="group"/>
  <xsl:choose>
    <xsl:when test="$group = 'system'">System</xsl:when>
    <xsl:when test="$name = 'DestroyJavaVM'">System</xsl:when>
    <xsl:when test="$name = 'Incoming mail server'"    >Mail server</xsl:when>
    <xsl:when test="$name = 'main'"                    >Tomcat</xsl:when>
    <xsl:when test="starts-with($name, 'http-')"       >Tomcat</xsl:when>
    <xsl:when test="starts-with($name, 'TP-Processor')">Tomcat</xsl:when>
    <xsl:when test="starts-with($name, 'TP-Monitor')"  >Tomcat</xsl:when>
    <xsl:when test="starts-with($name, 'Catalina-')">Tomcat</xsl:when>
    <xsl:when test="starts-with($name, 'ContainerBackgroundProcessor')">Tomcat</xsl:when>
    <xsl:when test="starts-with($name, 'NotificationThread')"      >PageSeeder</xsl:when>
    <xsl:when test="starts-with($name, 'Publish Scheduler Thread')">PageSeeder</xsl:when>
    <xsl:when test="starts-with($name, 'ps-')">PageSeeder</xsl:when>
    <xsl:when test="starts-with($name, 'logback-')">Logback</xsl:when>
    <xsl:when test="starts-with($name, 'C3P0Pooled')">SQL Connection Pool</xsl:when>
    <xsl:when test="starts-with($name, 'com.mchange.v2')">SQL Connection Pool</xsl:when>
    <xsl:when test="starts-with($name, 'Abandoned connection cleanup')">JDBC Connector</xsl:when>
    <xsl:when test="starts-with($name, 'net.sf.ehcache')">EHCache Manager</xsl:when>
    <xsl:when test="starts-with($name, 'Poller SunPKCS11-Darwin')">System</xsl:when>
    <xsl:when test="ends-with($name, '.data')">EHCache Data</xsl:when>
    <xsl:when test="starts-with($name, 'indexing-p')">Flint</xsl:when>
  </xsl:choose>
</xsl:function>

<!--
  Formats a size in bytes using bytes, kB, MB or GB

  @param size the size in bytes
  @return the formatted size in bytes, KB or MB
-->
<xsl:function name="f:format-byte-size" as="xs:string">
  <xsl:param name="size" as="xs:integer"/>
  <xsl:value-of>
    <xsl:choose>
      <xsl:when test="$size gt 1000000000"><xsl:value-of select="format-number($size div 1000000000, '#.0')" /> GB</xsl:when>
      <xsl:when test="$size gt 1000000"><xsl:value-of select="format-number($size div 1000000, '#.0')" /> MB</xsl:when>
      <xsl:when test="$size gt 1000"><xsl:value-of select="format-number($size div 1000, '#.0')" /> kB</xsl:when>
      <xsl:otherwise><xsl:value-of select="$size" /> bytes</xsl:otherwise>
    </xsl:choose>
  </xsl:value-of>
</xsl:function>

</xsl:stylesheet>
