<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-member-profile']" mode="html-title" as="xs:string*">
  <xsl:sequence select="(//content/member/fullname)"/>
</xsl:template>

<xsl:template match="root[@service='admin-member-profile']" mode="main-content">
<div class="main-content">
  <xsl:variable name="member"         select="//content/member"/>
  <xsl:variable name="personal-group" select="//content/group"/>
  <main-panel>
    <h1 class="page-title"><svg-icon name="member-groups"/> Account profile</h1>

    <xsl:if test="not($member)">
      <callout-box type="error">
        <p>This member does not exist.</p>
      </callout-box>
    </xsl:if>

    <xsl:for-each select="$member">
      <admin-account-profile v-bind:has-personal-group="{if ($personal-group) then 'true' else 'false'}"
                             v-bind:identity-config="{f:to-json(//(external-identity|identity-config)[1])}"
                             v-bind:member="{f:to-json($member)}"
                             v-bind:max-attachment-size="{//constants/@max-attachment-size}"/>
    </xsl:for-each>

  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
