<?xml version="1.0"?>
<!--
  Template used when a new member has been created and invited to a group

  @version 5.9904
-->
<xsl:stylesheet version="2.0"
        xmlns:f="http://www.pageseeder.com/function"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="#all">

<xsl:import href="_frame.xsl"/>

<!-- Subject and metadata -->
<xsl:template match="notification[@template='membership-new-member']" mode="meta">
  <title>[<xsl:value-of select="membership/(group|project)/@name" />] <xsl:value-of select=" if (membership/project) then 'Project ' else 'Group '"/>
    <xsl:value-of select="if (membership/@status = 'invited') then 'invitation' else 'registration'"/></title>
</xsl:template>

<!-- Banner -->
<xsl:template match="notification[@template='membership-new-member']" mode="banner">
  <p wrapper-class="membership-wrap"><xsl:value-of select="$appname" /> group invitation</p>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='membership-new-member']" mode="body">
  <xsl:variable name="firstname" select="membership/member/@firstname"/>
  <h3>
    <xsl:choose>
      <xsl:when test="$firstname!='Member'">Hi <xsl:value-of select="$firstname"/>,</xsl:when>
      <xsl:otherwise>Hi,</xsl:otherwise>
    </xsl:choose>
  </h3>

  <p class="lead">
  <xsl:choose>
    <xsl:when test="inviter"><b><xsl:value-of select="inviter/fullname"/></b> has <xsl:value-of
    select="if (membership/@status = 'invited') then 'invited you to join' else 'added you to'"/></xsl:when>
    <xsl:otherwise>You have been <xsl:value-of
    select="if (membership/@status = 'invited') then 'invited to join' else 'added to'"/></xsl:otherwise>
  </xsl:choose> the <xsl:value-of select=" if (membership/project) then 'project ' else 'group '"/><b><xsl:value-of select="membership/(group|project)/@name" /></b>
  on <xsl:value-of select="$appname" /> at <a href="{$homepage}"><xsl:value-of select="f:hostname($homepage)" /></a>.</p>

  <!-- Copy the welcome message -->
  <xsl:if test="membership/(group|project)/message">
    <p><xsl:copy-of select="f:text-to-html(membership/(group|project)/message)" /></p>
  </xsl:if>

  <p>You must click on the button below to get started before being able to use <xsl:value-of select="$appname" />.</p>
  <xsl:sequence select="f:button(concat($linksprefix, '/getstarted?member=', membership/member/@id, '&amp;token=', @token), 'Get started')"/>

  <p class="last">This link will be valid for the next <xsl:value-of
    select="f:get-expiration(/notification/organization/token[@type='activate-member'], 'P2D')" />.</p>

  <xsl:if test="membership/@status = 'invited'">
    <p class="last">Disregard this email, if you do not wish to join.</p>
  </xsl:if>
</xsl:template>

<!-- Footer -->
<xsl:template match="notification[@template='membership-new-member']" mode="footer">
  <xsl:call-template name="noreply"/>
  <p>You received this email because a <xsl:value-of select="$appname" /> member created an account for you and
  invited you to join group <i><xsl:value-of select="membership/(group|project)/@name" /></i> on
  <a href="{$homepage}"><xsl:value-of select="f:hostname($homepage)"/></a>.</p>
  <xsl:if test="organization/footer/@text">
    <p><xsl:value-of select="organization/footer/@text"/></p>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
