<?xml version="1.0"?>
<!--
  This module defines the common part of emails that need to be modified such
  as the header and footer and variables reused in other templates.

  To modify the styles, update the file `styles.css`
-->
<xsl:stylesheet version="2.0"
        xmlns:f="http://www.pageseeder.com/function"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="f">

<!-- Host URL (when using SDK not available via /notification when using SDK) -->
<xsl:variable name="host-url"  select="if (/notification/@hosturl) then /notification/@hosturl else 'https://ps.pageseeder.com/ps'"/>

<!-- email domain -->
<xsl:variable name="emaildomain"  select="/notification/@emaildomain"/>

<!-- links prefix -->
<xsl:variable name="linksprefix"  select="if (/notification/organization/links/@prefix) then /notification/organization/links/@prefix else
                                          if (/notification/@hosturl) then concat(/notification/@hosturl, '/email') else 'https://ps.pageseeder.com/ps/email'"/>

<!-- homepage -->
<xsl:variable name="homepage"  select="if (/notification/organization/application/@homepage) then /notification/organization/application/@homepage else
                                       if (/notification/@hosturl) then concat(/notification/@hosturl, '/') else 'https://ps.pageseeder.com/ps'"/>

<!-- application name -->
<xsl:variable name="appname"  select="if (/notification/organization/application/@name) then /notification/organization/application/@name else 'PageSeeder'"/>

<!-- Base URL for images -->
<xsl:variable name="images-url"  select="if (/notification/organization/images/@prefix) then /notification/organization/images/@prefix else
                                         concat($host-url, '/weborganic/email')" />

<!-- Header image (may need to be modified during testing before images are available on host) -->
<xsl:variable name="header-image-url"  select="if (/notification/organization/images[@logo-filename and @prefix]) then concat(/notification/organization/images/@prefix, '/', /notification/organization/images/@logo-filename) else
                                               if (/notification/organization/images/@logo-filename) then concat($host-url, '/woconfig/', /notification/organization/@project, '/organization/', /notification/organization/images/@logo-filename) else
                                               concat($images-url, '/ps-header-logo-white.png')" />

<!--
  Default header template
-->
<xsl:template match="notification" mode="header">
<table width="100%" style="width:100%; border-spacing:0; border-collapse: collapse;">
  <tr>
    <td style="border-spacing:0">
      <a href="{$homepage}" class="header-logo" title="{$appname}"
      ><img src="{$header-image-url}" class="header-logo_img" border="0" alt="" height="45"/></a>
    </td>
    <td style="border-spacing:0" align="right">
      <xsl:if test="group and not(group/@name = 'admin') or comment/context/group">
        <xsl:variable name="group" select="if (group) then group else (comment/context/group)[1]"/>
        <h4 class="header-title"><xsl:value-of select="if ($group/@title) then $group/@title else $group/@name"/></h4>
      </xsl:if>
    </td>
  </tr>
</table>
</xsl:template>

<!--
 Default footer template
-->
<xsl:template match="notification" mode="footer">
  <xsl:if test="not(@template = 'new-comment' or @template = 'external' and not(message/replyto))">
    <xsl:call-template name="noreply"/>
  </xsl:if>
  <xsl:choose>
  <xsl:when test="group and group/@name != 'admin'">
    <p>You received this message because you are part of the <i><xsl:value-of select="group/@name" /></i> group
    on <a href="{$homepage}"><xsl:value-of select="f:hostname($homepage)"/></a>. Manage your ongoing
    notification settings using your <a href="{$linksprefix}/mygroups">group options</a>
    or <a href="{$linksprefix}/unsubscribe?group={group/@name}&amp;token={@unsubscribetoken}">unsubscribe</a> from this group.</p>
  </xsl:when>
  <xsl:otherwise>
    <p>You received this message because you have an account on
    <a href="{$homepage}"><xsl:value-of select="f:hostname($homepage)"/></a>.</p>
  </xsl:otherwise>
</xsl:choose>
<xsl:if test="organization/footer/@text">
  <p><xsl:value-of select="organization/footer/@text"/></p>
</xsl:if>
</xsl:template>

<!--
  Return the 'DO NOT REPLY' message
-->
<xsl:template name="noreply">
  <p>This is an automatically generated email&#x2014;please do not reply to this email.</p>
</xsl:template>

</xsl:stylesheet>