<!--
  Indexing transformations for WEBP images.

  The source XML follows the structure below:

  ```
    <index-data mediatype="image/webp">
      <document level="metadata"> ... </document>
      <workflow> ... </workflow>
      <content source="tika"> ... </content>
    </index-data>
  ```

  @author Christophe Lauret
  @author Jean-Baptiste Reure

  @version 5.9900
-->
<xsl:transform  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:psf="http://www.pageseeder.com/function"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<!-- We extend the default index module -->
<xsl:import href="index.xsl" />

<!-- indexXFields group property -->
<xsl:param name="ps-indexXFields" select="'false'" />

<!--
  Generate the fields specific to Webp from content extracted by Tika.

  ```
  <content source="tika">
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <meta name="X-Parsed-By" content="org.apache.tika.parser.DefaultParser"/>
        <meta name="X-Parsed-By" content="org.apache.tika.parser.image.WebPParser"/>
        <meta name="File Size" content="213690 bytes"/>
        <meta name="File Modified Date" content="Wed Mar 17 08:38:02 +00:00 2021"/>
        <meta name="Filename" content="IMG_4653.webp"/>
        <meta name="Image Height" content="640"/>
        <meta name="Content-Type" content="image/webp"/>
        <meta name="Image Width" content="640"/>
        <title/>
      </head>
      <body/>
    </html>
  </content>
  ```
-->
<xsl:template match="index-data[@mediatype='image/webp']/content" mode="ixml" priority="2">
  <xsl:for-each select="descendant::xhtml:head">

    <!-- Image dimensions -->
    <xsl:if test="xhtml:meta[@name = 'Image Width'] and xhtml:meta[@name = 'Image Height']">
      <xsl:sequence select="psf:ps-dimension(xhtml:meta[@name = 'Image Width']/@content, xhtml:meta[@name = 'Image Height']/@content)"/>
    </xsl:if>

    <xsl:sequence select="psf:exif-media-dates(., /index-data/document/documentinfo/uri/@created)" />

    <!-- Metadata reported by Tika if any -->
    <xsl:for-each select="xhtml:meta[not(@name = 'X-Parsed-By' or @name = 'Content-type')][$ps-indexXFields = 'true']">
      <xsl:sort select="lower-case(@name)"/>
      <xsl:sequence select="psf:x-field(@name, @content)"/>
    </xsl:for-each>

  </xsl:for-each>
</xsl:template>

</xsl:transform>
