UPDATE CLIENT SET Scopes = CONCAT(Scopes, ' all') WHERE Scopes IS NOT NULL;

UPDATE CLIENT SET Scopes = 'all' WHERE Scopes IS NULL;

DROP TABLE URI_FOR_URI;

ALTER TABLE URI
    DROP Title,
    ADD  PathHash VARBINARY(32) NULL,
    DROP INDEX URI_key;

UPDATE URI U INNER JOIN HOST H ON U.HostID = H.HostID
    SET U.PathHash = UNHEX(SHA2(U.Path, 256))
    WHERE U.Path IS NOT NULL
    AND (H.ExternalFlag = '1' OR U.Path NOT LIKE '/ps/%');

UPDATE URI U INNER JOIN HOST H ON U.HostID = H.HostID
    SET U.PathHash = UNHEX(0)
    WHERE (H.ExternalFlag IS NULL OR H.ExternalFlag = '0') AND U.Path LIKE '/ps/%';

ALTER TABLE URI
    ADD UNIQUE KEY URI_key (Scheme,HostID,Port,Path,PathHash);

CREATE INDEX UserTitle_idx ON URI(UserTitle(100));

ALTER TABLE DGROUP
    DROP Abbreviation,
    DROP SiteFormat,
    DROP Precedence,
    DROP CommentsModified,
    DROP URIsModified,
    DROP XRefsModified;

ALTER TABLE HOST
    MODIFY Name VARCHAR(255) NULL;

ALTER TABLE HOSTALIAS
    MODIFY Name VARCHAR(255) NULL;

UPDATE DATABASE_METADATA SET Version='6.10';