UPDATE URI SET LastModified = NULL;

ALTER TABLE URI
    MODIFY LastModified DATETIME NULL,
    MODIFY Description TEXT NULL,
    CHANGE COLUMN DateTime DocID VARCHAR(100) NULL,
    ADD Labels VARCHAR(250) NULL,
    ADD Size BIGINT NULL,
    ADD Archived TINYINT NULL,
    ADD Folder TINYINT NULL,
    ADD DraftEditXLinkID INTEGER NULL,
    ADD INDEX DraftEditXLinkID_idx (DraftEditXLinkID),
    ADD FOREIGN KEY (DraftEditXLinkID) REFERENCES XLINK(XLinkID);

UPDATE URI SET Folder = 1 WHERE Type = "folder";

UPDATE MEMBER SET Email = NULL WHERE Email = "No Email";

UPDATE URI, XLINK SET URI.labels=REPLACE(REPLACE(XLINK.properties,"label=",""),"|",",") WHERE XLINK.xlinkid=URI.xlinkid;

UPDATE URI, XLINK SET XLINK.properties=CONCAT(XLINK.properties, "description=", REPLACE(URI.description, "|", "/||"), "|") WHERE XLINK.xlinkid=URI.xlinkid AND URI.description IS NOT NULL;

UPDATE URI, XLINK SET XLINK.properties=CONCAT(XLINK.properties, "docid=", URI.docid, "|") WHERE XLINK.xlinkid=URI.xlinkid AND URI.docid IS NOT NULL;

ALTER TABLE XLINK
    ADD Type VARCHAR(250) NULL;

ALTER TABLE DGROUP
    ADD Title VARCHAR(100) NULL,
    ADD CommentsModified DATETIME NULL,
    ADD URIsModified DATETIME NULL;

ALTER TABLE MEMBER_FOR_DGROUP
    ADD Created DATETIME NULL;

ALTER TABLE HOST
    ADD ExternalFlag TINYINT NULL;

CREATE TABLE DGROUP_FOR_DGROUP(
    GroupForGroupID INTEGER AUTO_INCREMENT PRIMARY KEY,
    GroupID INTEGER NOT NULL,
    MemberGroupID INTEGER NOT NULL,
    Listed TINYINT NULL,
    Notification VARCHAR(20) NULL,
    RoleFlags VARCHAR(20) NULL,
        INDEX GroupID_540_2_idx (GroupID),
        FOREIGN KEY (GroupID) REFERENCES DGROUP(GroupID),
        INDEX MemberGroupID_540_idx (MemberGroupID),
        FOREIGN KEY (MemberGroupID) REFERENCES DGROUP(GroupID)
    ) ENGINE = InnoDB;

CREATE TABLE XLINK_FOR_ATTACHEDXLINK(
    XLinkForAttachedXLinkID INTEGER AUTO_INCREMENT PRIMARY KEY,
    XLinkID INTEGER NOT NULL,
    AttachedXLinkID INTEGER NOT NULL,
    Role VARCHAR(250) NULL,
        INDEX XLinkID_540_idx (XLinkID),
        FOREIGN KEY (XLinkID) REFERENCES XLINK(XLinkID),
        INDEX AttachedXLinkID_540_idx (AttachedXLinkID),
        FOREIGN KEY (AttachedXLinkID) REFERENCES XLINK(XLinkID)
    ) ENGINE = InnoDB;

CREATE TABLE DGROUP_FOR_URI(
    GroupForURIID INTEGER AUTO_INCREMENT PRIMARY KEY,
    GroupID INTEGER NOT NULL,
    URIID INTEGER NOT NULL,
    Created DATETIME NULL,
    Title VARCHAR(250) NULL,
    Description TEXT NULL,
    Labels VARCHAR(250) NULL,
    XLinkID INTEGER NULL,
    Archived TINYINT NULL,
    Folder TINYINT NULL,
    CommentsModified DATETIME NULL,
        INDEX GroupID_540_idx (GroupID),
        FOREIGN KEY (GroupID) REFERENCES DGROUP(GroupID),
        INDEX URIID_540_idx (URIID),
        FOREIGN KEY (URIID) REFERENCES URI(URIID),
        INDEX XLinkID_540_idx (XLinkID),
        FOREIGN KEY (XLinkID) REFERENCES XLINK(XLinkID)
    ) ENGINE = InnoDB;

CREATE INDEX XLink_Type_idx ON XLINK(Type);

CREATE INDEX XLink_Status_idx ON XLINK(Status);

CREATE INDEX XLink_CreationDate_idx ON XLINK(CreationDate);

CREATE INDEX XLink_AssignedDate_idx ON XLINK(AssignedDate);

CREATE INDEX XLink_DueDate_idx ON XLINK(DueDate);

UPDATE DATABASE_METADATA SET Version='5.40';

