create table locator(
        locatorid serial primary key,
        fragment varchar(250) null,
        accepted boolean not null,
        behavior varchar(80) null,
        uriid integer null,
            unique (uriid,fragment)
        );

create table dgroup(
        groupid serial primary key,
        groupname varchar(60) null,
        groupdesc varchar(250) null,
        defaultlocatorid integer null,
        controlgroupname varchar(60) null,
        detailsform varchar(150) null,
        owner varchar(100) null,
        message text null,
        flags varchar(20) null,
        ownerdirectory varchar(60) null,
        homeurl varchar(250) null,
        title varchar(100) null,
        indexversion integer null,
            foreign key (defaultlocatorid) references locator(locatorid),
            unique (groupname)
        );

create table host(
        hostid serial primary key,
        name varchar(255) null,
        externalflag boolean null,
        virtualflag boolean null,
            unique (name)
        );

create table member(
        memberid serial primary key,
        firstname varchar(50) null,
        surname varchar(50) null,
        email varchar(100) null,
        username varchar(100) null,
        password varchar(100) null,
        submitpref varchar(20) null,
        bouncereceived integer null,
        externaluserid varchar(100) null,
        created timestamp(3) null,
        activated timestamp(3) null,
        lastlogin timestamp(3) null,
        lastpasswordchange timestamp(3) null,
        emaildomain varchar(100) null
        );

create unique index member_username_key on member (lower(username));

create unique index member_email_key on member (lower(email));

create table member_group_details(
        membergroupdetailsid serial primary key,
        field1 varchar(100) null,
        field2 varchar(100) null,
        field3 varchar(100) null,
        field4 varchar(100) null,
        field5 varchar(100) null,
        field6 varchar(100) null,
        field7 varchar(100) null,
        field8 varchar(100) null,
        field9 varchar(100) null,
        field10 varchar(100) null,
        field11 varchar(100) null,
        field12 varchar(100) null,
        field13 varchar(100) null,
        field14 varchar(100) null,
        field15 varchar(100) null
        );

create table xlink(
        xlinkid serial primary key,
        accepted boolean not null,
        moderatoronly boolean not null,
        contentrole varchar(250) null,
        contenttitle varchar(250) null,
        authorname varchar(100) null,
        authoremail varchar(100) null,
        memberid integer null,
        creationdate timestamp(3) null,
        moderatorid integer null,
        authoronly boolean not null,
        externaluserid varchar(100) null,
        properties text null,
        modifieddate timestamp(3) null,
        statuschangeddate timestamp(3) null,
        statuschangedbyid integer null,
        status varchar(40) null,
        assignedtoid integer null,
        assigneddate timestamp(3) null,
        duedate timestamp(3) null,
        priority varchar(40) null,
        type varchar(250) null,
        threadendxlinkid integer null,
            foreign key (threadendxlinkid) references xlink(xlinkid),
            foreign key (memberid) references member(memberid),
            foreign key (moderatorid) references member(memberid),
            foreign key (statuschangedbyid) references member(memberid),
            foreign key (assignedtoid) references member(memberid)
        );

create table uri(
        uriid serial primary key,
        docid varchar(100) null,
        scheme varchar(20) null,
        path varchar(500) null,
        parentpath varchar(500) null,
        hostid integer null,
        port integer null,
        behavior varchar(80) null,
        lastmodified timestamp(3) null,
        description text null,
        datecreated timestamp(3) null,
        datearchived timestamp(3) null,
        xlinkid integer null,
        usertitle varchar(250) null,
        type varchar(100) null,
        labels varchar(250) null,
        size bigint null,
        archived boolean null,
        folder boolean null,
        drafteditxlinkid integer null,
        pathhash bytea null,
            foreign key (hostid) references host(hostid),
            foreign key (xlinkid) references xlink(xlinkid),
            foreign key (drafteditxlinkid) references xlink(xlinkid)
        );

create unique index uri_key on uri (scheme,hostid,port,lower(path),pathhash);

alter table locator
  add foreign key (uriid) references uri(uriid);

create table moderator(
        moderatorid serial primary key,
        quota integer null,
        quotareceived integer null
        );

create table dgroupuri(
        groupuriid serial primary key,
        scheme varchar(20) null,
        path varchar(250) null,
        hostid integer null,
        port integer null,
            foreign key (hostid) references host(hostid)
        );

create unique index dgroupuri_key on dgroupuri (scheme,hostid,port,lower(path));

create table uri_for_dgroupuri(
        groupuriid integer not null,
        uriid integer not null,
            foreign key (groupuriid) references dgroupuri(groupuriid),
            foreign key (uriid) references uri(uriid)
        );

create table member_for_dgroup(
        memberforgroupid serial primary key,
        listed boolean not null,
        notification varchar(20) null,
        groupid integer not null,
        memberid integer null,
        moderatorid integer null,
        editor boolean not null,
        membergroupdetailsid integer null,
        created timestamp(3) null,
        editorflags varchar(20) null,
            foreign key (groupid) references dgroup(groupid),
            foreign key (memberid) references member(memberid),
            foreign key (moderatorid) references moderator(moderatorid),
            foreign key (membergroupdetailsid) references member_group_details(membergroupdetailsid),
            unique (groupid,memberid)
        );

create table dgroupuri_for_dgroup(
        groupuriforgroupid serial primary key,
        groupid integer not null,
        groupuriid integer not null,
        edituris boolean null,
            unique (groupid,groupuriid),
            foreign key (groupuriid) references dgroupuri(groupuriid),
            foreign key (groupid) references dgroup(groupid)
        );

create table xlink_for_xlink(
        replytoid integer not null,
        replyid integer not null,
            foreign key (replytoid) references xlink(xlinkid),
            foreign key (replyid) references xlink(xlinkid)
        );

create table hostalias(
        hostaliasid serial primary key,
        name varchar(255) null,
        hostid integer not null,
            foreign key (hostid) references host(hostid)
        );

create unique index host_alias_name_key on hostalias (name);

create table content(
        contentid serial primary key,
        type varchar(100) null,
        data text null,
        xlinkid integer not null,
        binarydata bytea null,
            foreign key (xlinkid) references xlink(xlinkid)
        );

create table locator_for_xlink(
        locatorforxlinkid serial primary key,
        role varchar(250) null,
        title varchar(250) null,
        locatorid integer not null,
        xlinkid integer null,
        label varchar(100) null,
        contentid integer null,
            foreign key (locatorid) references locator(locatorid),
            foreign key (xlinkid) references xlink(xlinkid),
            foreign key (contentid) references content(contentid)
        );

create table dgroup_for_xlink(
        groupforxlinkid serial primary key,
        xlinkid integer not null,
        groupid integer null,
            foreign key (xlinkid) references xlink(xlinkid),
            foreign key (groupid) references dgroup(groupid),
            unique (groupid, xlinkid)
        );

create table dgroup_for_dgroup(
    groupforgroupid serial primary key,
    groupid integer not null,
    membergroupid integer not null,
    listed boolean null,
    notification varchar(20) null,
    roleflags varchar(20) null,
        foreign key (groupid) references dgroup(groupid),
        foreign key (membergroupid) references dgroup(groupid),
        unique (groupid,membergroupid)
    );

create table xlink_for_attachedxlink(
    xlinkforattachedxlinkid serial primary key,
    xlinkid integer not null,
    attachedxlinkid integer not null,
    role varchar(250) null,
        foreign key (xlinkid) references xlink(xlinkid),
        foreign key (attachedxlinkid) references xlink(xlinkid)
    );

create table client(
  clientid            serial primary key,
  name                varchar(255) null,
  identifier          varchar(16)  null,
  secrethash          varchar(64)  null,
  granttype           varchar(20)  null,
  redirecturi         varchar(255) null,
  clienturi           varchar(255) null,
  requireconsent      boolean      null,
  confidential        boolean      null,
  accesstokenmaxage   integer      null,
  refreshtokenmaxage  integer      null,
  scopes              varchar(255) null,
  memberid            integer      null,
  description         varchar(255) null,
  webhooksecret       varchar(64)  null,
  datecreated         timestamp(3) null,
  datemodified        timestamp(3) null,
  datelasttoken       timestamp(3) null,
  appname             varchar(32)  null,
    unique (identifier),
    unique (name),
    foreign key (memberid) references member(memberid)
  );

create table persistent_token(
  tokenid     serial primary key,
  tokenhash   varchar(50)   null,
  memberid    integer       null,
  clientid    integer       null,
  dateissued  timestamp(3)  null,
  dateexpires timestamp(3)  null,
  scopes      varchar (255) null,
  data        varchar (255) null,
    foreign key (clientid) references client(clientid),
    foreign key (memberid) references member(memberid)
);

create table webhook (
  webhookid       serial primary key,
  clientid        integer not null,
  datecreated     timestamp(3) not null,
  datemodified    timestamp(3) not null,
  name            varchar(64)  null,
  url             varchar(255) not null,
  server          boolean      not null,
  projects        varchar(255) null,
  groups          varchar(255) null,
  events          varchar(500) null,
  object          varchar(10)  not null,
  format          varchar(5)   not null,
  insecuressl     boolean      not null,
  status          varchar(15)  not null,
    unique (name),
    foreign key (clientid) references client(clientid)
  );

create table publication_for_locator (
        xlinkid   integer not null,
        locatorid integer not null,
            foreign key (xlinkid) references xlink(xlinkid),
            foreign key (locatorid) references locator(locatorid),
            unique (xlinkid,locatorid)
        );

create table authenticator (
        authenticatorid serial primary key,
        memberid        integer      not null,
        publicid        varchar(16)  not null,
        type            varchar(20)  not null,
        name            varchar(50)  null,
        confidential    bytea        null,
        parameters      varchar(100) null,
        credentialid    bytea        null,
        publickey       bytea        null,
        verified        boolean      not null,
        signcount       integer      null,
        created         timestamp(3) not null,
        lastused        timestamp(3) null,
            unique (publicid),
            foreign key (memberid) references member(memberid)
        );

create table database_metadata(
        version varchar(20) null
        );

insert into database_metadata values('6.20');

create index controlgroupname_idx on dgroup(controlgroupname);

create index grouptitle_idx on dgroup(title);

create index firstname_idx on member(firstname);

create index surname_idx on member(surname);

create index email_idx on member(email);

create index emaildomain_idx on member(emaildomain);

create index docid_idx on uri(docid);

create index usertitle_idx on uri(usertitle);

create index path_idx on uri(path);

create index path2_idx on dgroupuri(path);

create index parentpath_idx on uri(parentpath);

create index contentrole_idx on xlink(contentrole);

create index contenttitle_idx on xlink(contenttitle);

create index xlink_type_idx on xlink(type);

create index xlink_status_idx on xlink(status);

create index xlink_creationdate_idx on xlink(creationdate);

create index xlink_assigneddate_idx on xlink(assigneddate);

create index xlink_duedate_idx on xlink(duedate);

create index client_name_idx on client(name);

create index client_identifier_idx on client(identifier);

create index persistent_tokenhash_idx on persistent_token(tokenhash);

create index grouptitle_lower_idx on dgroup(lower(title));

create index path_lower_idx on uri(lower(path));

create index path2_lower_idx on dgroupuri(lower(path));

create index parentpath_lower_idx on uri(lower(parentpath));

create index firstname_lower_idx on member(lower(firstname));

create index surname_lower_idx on member(lower(surname));

create index email_lower_idx on member(lower(email));

create index emaildomain_lower_idx on member(lower(emaildomain));

create index username_lower_idx on member(lower(username));

create index authoronly_idx on xlink(authoronly);

create index accepted_idx on xlink(accepted);

create index threadendxlinkid_idx on xlink(threadendxlinkid);

create index defaultlocatorid_idx on dgroup(defaultlocatorid);

create index xlink_memberid_idx on xlink(memberid);

create index xlink_moderatorid_idx on xlink(moderatorid);

create index xlink_statuschangedbyid_idx on xlink(statuschangedbyid);

create index xlink_assignedtoid_idx on xlink(assignedtoid);

create index uri_hostid_idx on uri(hostid);

create index uri_xlinkid_idx on uri(xlinkid);

create index uri_drafteditxlinkid_idx on uri(drafteditxlinkid);

create index locator_uriid_idx on locator(uriid);

create index dgroupuri_hostid_idx on dgroupuri(hostid);

create index ufg_groupuriid_idx on uri_for_dgroupuri(groupuriid);

create index ufg_uriid_idx on uri_for_dgroupuri(uriid);

create index mfg_groupid_idx on member_for_dgroup(groupid);

create index mfg_memberid_idx on member_for_dgroup(memberid);

create index mfg_moderatorid_idx on member_for_dgroup(moderatorid);

create index mfg_membergroupdetailsid_idx on member_for_dgroup(membergroupdetailsid);

create index gufg_groupuriid_idx on dgroupuri_for_dgroup(groupuriid);

create index gufg_groupid_idx on dgroupuri_for_dgroup(groupid);

create index xfx_replytoid_idx on xlink_for_xlink(replytoid);

create index xfx_replyid_idx on xlink_for_xlink(replyid);

create index hostalias_hostid_idx on hostalias(hostid);

create index content_xlinkid_idx on content(xlinkid);

create index lfx_role_idx on locator_for_xlink(role);

create index lfx_locatorid_idx on locator_for_xlink(locatorid);

create index lfx_xlinkid_idx on locator_for_xlink(xlinkid);

create index lfx_contentid_idx on locator_for_xlink(contentid);

create index gfx_xlinkid_idx on dgroup_for_xlink(xlinkid);

create index gfx_groupid_idx on dgroup_for_xlink(groupid);

create index gfg_groupid_idx on dgroup_for_dgroup(groupid);

create index gfg_membergroupid_idx on dgroup_for_dgroup(membergroupid);

create index xfax_xlinkid_idx on xlink_for_attachedxlink(xlinkid);

create index xfax_attachedxlinkid_idx on xlink_for_attachedxlink(attachedxlinkid);

create index client_memberid_idx on client(memberid);

create index pt_clientid_idx on persistent_token(clientid);

create index pt_memberid_idx on persistent_token(memberid);

create index webhook_clientid_idx on webhook(clientid);

create index pfl_xlinkid_idx on publication_for_locator(xlinkid);

create index pfl_locatorid_idx on publication_for_locator(locatorid);

