/**
 * $Id: HTCTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.ut.tests;

import  java.io.File;
import  java.io.InputStream;

import  junit.framework.Assert;
import  junit.framework.AssertionFailedError;
import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.*;


/**
 * Test for the HTC <i>JWare/AntX</i> test superclasses. Modified from original; removed
 * all batch-failure tests.
 *
 * @since    JWare0.6
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class HTCTest extends HTC /* We need this for batchFailure and ThreadLocals */
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new HTCTest test case.
     **/
    public HTCTest(String methodName)
    {
        super("HTC::",methodName);
    }


    /**
     * Create full test suite for HTC.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(HTCTest.class);
    }


    /**
     * Create baseline test suite for HTC (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// --------------------------------------- [ Misc Factory Methods ] ----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    /** Exposes some internals of HTC. [modified-from-HMTTest] **/
    public final static class HTCExposer extends HTC {
        public HTCExposer() {
            super();
        }
        public HTCExposer(String meth) {
            super(meth);
        }
        public HTCExposer(String grpid, String meth) {
            super(grpid,meth);
        }
    }

    public void testFailRequire()
    {
        try { require_(false,"@failRequire"); Assert.fail("require(false)"); }
        catch(TestError x) { Assert.assertTrue(x.getMessage().indexOf("@failRequire")>=0); }
    }

    public void testFailEnsure()
    {
        try { ensure_(false,"@failEnsure"); Assert.fail("ensure(false)"); }
        catch(TestError x) { Assert.assertTrue(x.getMessage().indexOf("@failEnsure")>=0); }
    }

    public void testFailVerify()
    {
        try { verify_(false,"@failVerify"); Assert.fail("verify(false)"); }
        catch(TestError x) { Assert.assertTrue(x.getMessage().indexOf("@failVerify")>=0); }
    }

    public void testFailASAP()
    {
        try
        { HTC.failASAP("@failASAP_"); }
        catch(AssertionFailedError x)
        { Assert.assertTrue(x.getMessage().indexOf("@failASAP_")>=0);
        return; }
        Assert.fail("failASAP broken");
    }

    public void testFailEqualASAP()
    {
        try
        { HTC.failEqualASAP("foo",new String("foo"),"@failEqualASAP_"); }
        catch(AssertionFailedError x)
        { Assert.assertTrue(x.getMessage().indexOf("@failEqualASAP_")>=0);
        return; }
        Assert.fail("failEqualASAP broken");
    }

    public void testFailNotEqualASAP()
    {
        try
        { HTC.failEqualASAP("foo","bar","@failNotEqualASAP_"); }
        catch(AssertionFailedError x)
        { Assert.assertTrue(x.getMessage().indexOf("@failNotEqualASAP_")>=0);
        return; }
        Assert.fail("failNotEqualASAP broken");
    }


// ---------------------------------------------------------------------------------------------------------
// Verify batch processing from a single thread (first) Note tests should not affect each other!
// [ R E M O V E D -- ssmc ]
// ---------------------------------------------------------------------------------------------------------
// ...


// ---------------------------------------------------------------------------------------------------------
// Test the (Not)Equal that all others depend on
// ---------------------------------------------------------------------------------------------------------

    public void testPassAssertEqual()
    {
        HTC.assertEqual("foo", new String("foo"));
    }

    public void testPassAssertNotEqual()
    {
        HTC.assertNotEqual("foo","bar");
    }

    public void testPassIdent()
    {
        Object o= new Double(Math.PI);
        HTC.assertIdent(o,o);
    }

    public void testPassNotIdent()
    {
        Object o1= new Double(Math.PI);
        Object o2= new Double(Math.PI);
        HTC.assertNotIdent(o1,o2);
        HTC.assertEqual(o1,o2);
    }

// ---------------------------------------------------------------------------------------------------------
// Test the Throwable-matching that all others depend on
// ---------------------------------------------------------------------------------------------------------

    public void testFindExpected()
    {
        Throwable t= new Throwable("Oh goody time to wreak havoc");
        assertExpected(t,"goody");
    }

    public void testNotFindExpected()
    {
        Throwable t= new Throwable("Peanut and Jelly");
        boolean happy=true;
        try { assertExpected(t,"Bologna"); happy=false; }
        catch(AssertionFailedError x) { assertExpected(x,"Barfage"); }
        HTC.assertTrue("Didn't find missing token",happy);
    }

    public void testFindExpectedOfKind()
    {
        Throwable t= new NullPointerException("Oh goody time to wreak havoc");
        assertExpected(t,RuntimeException.class,"havoc");
    }

    public void testNotFindExpectedOfKind()
    {
        Throwable t= new NullPointerException("Fish and Chips");
        boolean happy=true;
        try { assertExpected(t,ClassNotFoundException.class,"Chips"); happy=false; }
        catch(AssertionFailedError x) { assertExpected(x,"Barfage"); }
        HTC.assertTrue("Didn't match throwable class",happy);
    }

// ---------------------------------------------------------------------------------------------------------
// Test the Load of test class resources
// ---------------------------------------------------------------------------------------------------------

    public void testCanLoadClassResourcesAsStreams()
        throws Exception
    {
        InputStream ins = getFileResourceAsStream("HTCTest.xml");
        int Nc=0;
        while (ins.read() != -1) {
            m_stdout.print(".");
            Nc++;
        }
        ins.close();
        assertNotEqual(Nc,0,"Number HTCTest.xml bytes read");
    }


    public void testCanLoadClassResourcesAsFiles()
        throws Exception
    {
        File f = getFileResource("HTCTest.xml");
        java.io.FileReader fr = new java.io.FileReader(f);
        assertTrue(fr.ready(),"HTCTest reader ready");
        int Nc=0;
        while (fr.read() != -1) {
            m_stdout.print(".");
            Nc++;
        }
        fr.close();
        assertNotEqual(Nc,0,"Number HTCTest.xml bytes read");
    }

// ---------------------------------------------------------------------------------------------------------
// Test the Ant Build File bits work!
// ---------------------------------------------------------------------------------------------------------


    public void testCanLoadBuildFileResources()
        throws Exception
    {
        File f = getFileResource("HTCTest.xml");
        configureProject(f.getPath());
    }


    public void testCanExecuteTargetInBuildFile()
        throws Exception
    {
        configureProject(getFileResource("HTCTest.xml").getPath());
        executeTarget("geeksalute");
        assertNotEqual(getLog().indexOf("helloworld"),-1,"'geeksalute' target output");
    }
}

/* end-of-HTCTest.java */
