/**
 * $Id: HTCUtils.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.ut;

import  junit.framework.TestResult;
import  junit.framework.TestSuite;

/**
 * Collection of standalone <i>HTC</i> utility functions. Copied from original
 * JWare/foundation/ut.
 *
 * @since    JWare0.6
 * @author   ssmc, &copy;2002 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,test,helper
 **/

public final class HTCUtils
{

    /** Returned by {@linkplain #quickCheck} to indicate totally successful test run. **/
    public static final String OK= "OK";
    /** Returned by {@linkplain #quickCheck} to indicate problematic test run. **/
    public static final String NOT_OK= "NOT-OK";

    /**
     * Quick check test runner; aborts on first error or failure. Use another, more
     * sophisticated, test runner if any tests fail. Method can only be used by leaf
     * test class's <i>main</i> method.
     * @param tests test suite to be executed (non-null)
     **/
    public static final void quickCheck(TestSuite tests)
    {
        try{
            TestResult r= new HAbortingResult(1,1);
            tests.run(r);
            if (r.wasSuccessful()) {
                System.out.println(OK);
                System.exit(0);
            } else {
                java.util.Enumeration e;
                if (r.errorCount()>0) {
                    System.out.println("Had "+r.errorCount()+" Errors");
                    e= r.errors();
                    while (e.hasMoreElements()) {
                        System.out.println(e.nextElement());
                    }
                }
                if (r.failureCount()>0) {
                    System.out.println("Had "+r.failureCount()+" Failures");
                    e= r.failures();
                    while (e.hasMoreElements()) {
                        System.out.println(e.nextElement());
                    }
                }
            }
        }catch(Exception anyx){/*burp*/}
        System.out.println(NOT_OK);
        System.exit(-1);
    }

// ---------------------------------------------------------------------------------------------------------|
    private HTCUtils()
    {/*nope*/}
}

/* end-of-HTCUtils.java */
