/**
 * $Id: BuildInfoTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                                 EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.testsmodule.tasks;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;
import  com.idaremedia.apis.Buildstrs;

import  com.idaremedia.antx.BuildInfo;

/**
 * Unit test for <i>JWare/AntX</i> definition of its default {@linkplain Buildstrs}.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 * @see      com.idaremedia.apis.Buildstrs
 **/

public final class BuildInfoTest extends HTC
{
    private Buildstrs m_dynCopy;


    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Initializes new unit test case.
     **/
    public BuildInfoTest(String methodName)
    {
        super("AntX::BuildInfo::",methodName);
    }


    /**
     * Creates a full test suite for this Test class.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(BuildInfoTest.class);
    }


    /**
     * Create baseline test suite for BuildInfo (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


    /**
     * Verifies you can extract a shared copy of buildstrs and
     * clone existing instances.
     **/
    public void testCanonicalAPI()
    {
        assertEqual(m_dynCopy,BuildInfo.getInstance());
        Object copy= ((BuildInfo)BuildInfo.getInstance()).clone();
        assertNotIdent(copy,m_dynCopy);
        assertEqual(copy,m_dynCopy);
    }


    /**
     * Verifies that there is a string for each element (for some
     * fields, method verifies that string is not empty and|or just
     * whitespace).
     **/
    public void testAllStringsDefined()
    {
        assertEqual(m_dynCopy.getID(),"AntX");
        assertNotNil(m_dynCopy.getDisplayName(),"displayName");
        assertNotWhitespace(m_dynCopy.getVersion(),"version defined");
        assertNotWhitespace(m_dynCopy.getBuildVersion(),"build-version defined");

        assertNotNil(m_dynCopy.getNSPrefix(),"NS_Prefix");
        assertNotNil(m_dynCopy.getNSURI(),"NS_URI");
        assertNotNil(m_dynCopy.getPropertiesPrefix(),"Properties_Prefix");

        assertNotWhitespace(m_dynCopy.getAbbrDate(),"abbrDate defined");
        assertNotNil(m_dynCopy.getLongDate(),"longDate");

        assertNotNil(m_dynCopy.getOS(),"OS");
        assertNotNil(m_dynCopy.getBuilderID(),"builderID");
        assertNotNil(m_dynCopy.getBuilderCN(),"builderCN");
        assertNotNil(m_dynCopy.getHostID(),"hostID");

        assertNotNil(m_dynCopy.getUsedPaths(),"usedPaths");
    }


    /**
     * Dynamically create a reuseable BuildInfo instance.
     **/
    protected void setUp()
    {
        m_dynCopy= new BuildInfo();
    }


    /**
     * Zero-out member fields for garbage-collecting.
     **/
    protected void tearDown()
    {
        m_dynCopy= null;
    }
}

/* end-of-BuildInfoTest.java */
