/**
 * $Id: ManagerTaskTest.java 186 2007-03-16 13:42:35Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  java.util.Map;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.AntXFixture;
import  com.idaremedia.antx.helpers.Tk;
import  com.idaremedia.antx.starters.ManagerTask;
import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Unit test for {@linkplain com.idaremedia.antx.starters.ManagerTask}.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    api,test
 **/

public final class ManagerTaskTest extends HTC 
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new ManagerTask testcase.
     **/
    public ManagerTaskTest(String methodName)
    {
        super("ManagerTask::",methodName);
    }


    /**
     * Create full test suite for ManagerTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(ManagerTaskTest.class);
    }


    /**
     * Create baseline test suite for ManagerTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public static class EmptyManager extends ManagerTask {
        EmptyManager() {
            super("EmptyManagerTest:");
        }
    }

    static class IllegalManager extends ManagerTask {
        IllegalManager() {
            super("IllegalManagerTest:");
        }
    }

    public static class TypicalManager extends ManagerTask {
        TypicalManager() {
            super("TypicalManagerTest:");
        }
        TypicalManager(Project project) {
            super("TypicalManagerTest:");
            setProject(project);
        }
        public void setAction(String actionName) {
            m_actionName = Tk.lowercaseFrom(actionName);
        }
        public void setParam0(String methodName) {
            require_(methodName!=null,"setParam- nonzro param value");
            m_customParams.put("method",methodName);
        }
        public void execute() {
            verifyCanExecute_("exec");
            doAction(m_actionName,m_customParams,null);
        }
        public void doInstall(Map args) {
            System.out.println("INSTALL");
            installs++;
        }
        public void doUnInstall(Map args) {
            System.out.println("UNINSTALL");
            uninstalls++;
        }
        public void doIt(Map args) {
            String method = (String)args.get("method");
            if (method!=null) {
                doAction(method,args,null);
            } else {
                doAction("die",args,null);
            }
        }
        protected void doDIE(Map args) {
            throw new BuildException("Drats! I'm dead!");
        }
        private String m_actionName="DIE";
        int installs, uninstalls;
        private Map m_customParams =  AntXFixture.newMap();
    }



    protected void setUp() throws Exception
    {
        configureProjectFromResource("empty.xml");
    }

//  ---------------------------------------------------------------------------------------------------------
//  ------------------------------------------- [ The Test Cases ] ------------------------------------------
//  ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
         //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }


    public void testNoActionIntrospection_AntX05()
    {
        EmptyManager task = new EmptyManager();
        Project myproject = getProject();
        task.setProject(myproject);
        task.init();
        task.init();//NB:intentional twice!
        assertEqual(task.actionMethodCount(),0,"ActionMethodCount");
        assertEqual(task.validActionNames(null),"","ActionNameList");
    }


    public void testNoActionMethodsExecute_AntX05()
    {
        EmptyManager task = new EmptyManager();
        Project myproject = getProject();
        task.setProject(myproject);
        task.init();
        task.execute();
    }



    public void testIntrospectionFindsPublicMethodsOnly_AntX05()
    {
        TypicalManager task = new TypicalManager(getProject());
        task.init();
        assertEqual(task.actionMethodCount(),3,"Valid Action Count");
        String list = task.validActionNames(",");
        println("Valid Action Names:",list);
        assertTrue(list.indexOf("install")>=0,"Found 'install' action");
        assertTrue(list.indexOf("uninstall")>=0,"Found 'uninstall' action");
        assertFalse(list.indexOf("die")>=0,"Did not find 'die' action");
    }



    public void testIllegalActionMethodFails_AntX05()
    {
        TypicalManager task = new TypicalManager(getProject());
        try {
            task.execute();//NB:should look fer actions
            fail("Should not be able to execute 'die' action successfully!");
        } catch(BuildException bX) {
            String msg = bX.getMessage();
            println(msg);
            assertTrue(msg.indexOf("\"DIE\"")>0, "Unknown Action message");
        }
    }


    public void testWillIgnoreErrorIfNoHalt_AntX05()
    {
        TypicalManager task = new TypicalManager(getProject());
        task.setAction("IT");
        task.setHaltIfError(false);
        task.execute();
    }



    public void testActionsCalled_AntX05()
    {
        TypicalManager task = new TypicalManager(getProject());
        task.setAction("InstaLL");
        task.execute();
        assertEqual(task.installs,1,"Install Calls");
        task.setAction("uninsTAll");
        task.execute();
        assertEqual(task.installs,1,"Install Calls");
        assertEqual(task.uninstalls,1,"Uninstall Calls");
    }
    
    
    public void testCustomParamsHandled_AntX05()
    {
        TypicalManager task = new TypicalManager(getProject());
        task.setAction("it");
        task.setParam0("install");
        assertEqual(task.installs,0,"Install Calls Before");
        task.execute();
        assertEqual(task.installs,1,"Install Calls After");
    }


    public void testOnlyPublicManagerClassAllowed_AntX05()
    {
        IllegalManager task = new IllegalManager();
        try {
            task.init();
            fail("Should not be able to initialize a non-public manager task");
        } catch(IllegalStateException malformX) {/*burp*/}
    }
}

/* end-of-ManagerTaskTest.java */