/**
 * $Id: InitUISMTaskTest.java 187 2007-03-25 17:59:16Z ssmc $
 * Copyright 2002-2004,2007 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://antxtras.sf.net/          EMAIL- jware[at]users[dot]sourceforge[dot]net
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  java.io.File;
import  java.io.FileWriter;
import  java.io.PrintWriter;

import  junit.framework.TestSuite;
import  org.apache.tools.ant.util.FileUtils;

import  com.idaremedia.antx.AntXFixture;
import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.init.UISMBundle UISMBundle} and
 * {@linkplain com.idaremedia.antx.init.InitUISMTask InitUISMTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004,2007 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5.1
 * @.safety  single
 * @.group   impl,test
 **/

public final class InitUISMTaskTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new InitUISMTaskTest testcase.
     **/
    public InitUISMTaskTest(String methodName)
    {
        super("InitUISMTask::",methodName);
    }


    /**
     * Create full test suite for InitUISMTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(InitUISMTaskTest.class);
    }


    /**
     * Create baseline test suite for InitUISMTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();//new BaselineSuite(InitUISMTaskTest.class);
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    static final String TMP_TARGET = "theTest";
    static final String UISTRS_BUNDLE = "com.idaremedia.antx.tests.OtherUIStrings";
    static final String UISTRS_RESOURCE = "OtherUIStrings.properties";

    static final String BY_URL_DEBUG_MSG = "Copied UISM URL";
    static final String DBG_MSG_UISTRINGS = "DO NOT REMOVE. Helloworld";
    static final String DBG_MSG_OTHER_UISTRINGS = "GO AHEAD REMOVE ME. Byeworld";

    static final String _XML_tN="\"/>\n";
    static final String _XML_tf0="    <initmsgs_ action=\"install\" file=\"";
    static final String _XML_tu0="    <initmsgs_ action=\"install\" url=\"";

    private void writeBeginXML(PrintWriter w)
    {
        w.print("<?xml version=\"1.0\"?>\n<project name=\"UT\" basedir=\".\" default=\"theTest\">\n");
        w.print("  <taskdef name=\"initmsgs_\" classname=\"com.idaremedia.antx.init.InitUISMTask\"/>\n");
        w.print("  <target name=\"theTest\">\n");
    }

    private void writeEndXML(PrintWriter w)
    {
        w.print("    <initmsgs_ action=\"uninstall\"/>\n");
        w.print("  </target>\n");
        w.print("</project>\n");
    }

    private void writeByFileXML(PrintWriter w, String filepath)
    {
        writeBeginXML(w);
        w.print(_XML_tf0);
        w.print(filepath);
        w.print(_XML_tN);
        writeEndXML(w);
    }

    private void writeByURLXML(PrintWriter w, String url)
    {
        writeBeginXML(w);
        w.print(_XML_tu0);
        w.print(url);
        w.print(_XML_tN);
        writeEndXML(w);
    }

    private void configureTempBuildFileProject(boolean byFile) throws Exception
    {
        FileUtils fu= AntXFixture.fileUtils();
        File from = getFileResource(UISTRS_RESOURCE);
        File to = File.createTempFile("qatUIStrings-",".properties");
        fu.copyFile(from, to, null, true);
        File tempBuildFile = File.createTempFile("qatBuild-",".xml");
        PrintWriter w = new PrintWriter(new FileWriter(tempBuildFile));
        if (byFile) {
            writeByFileXML(w, to.getAbsolutePath());
        } else {
            writeByURLXML(w,to.toURL().toString());
        }
        w.close();
        configureProject(tempBuildFile.getPath());
        to.deleteOnExit();
        tempBuildFile.deleteOnExit();
    }

    private void verifyLoadable(String target, String type)
    {
        runTargetNoOutput(target);
        String fullLog = getFullLog();
        println("FFFFFFFFUUUUUUUUUULLLLL",fullLog);
        assertTrue(fullLog.indexOf(BY_URL_DEBUG_MSG) != -1,
                   "Loaded '"+type+"' option to bundle");
    }

// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        String n = getName();
        if (!n.endsWith("_Tmp")) {
            configureProjectFromResource("uism.xml");
        }
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testFailEmptyElement()
    {
        runExpecting("testEmptyElement","is empty task definition");
        println("BARFAGE:", getBuildException().getMessage());
    }

    public void testFailEmptyElementWithPropertyDefined()
    {
        runExpecting("testEmptyElementWithPropertyDefined", "is empty task definition w/ PPs");
        println("BARFAGE:", getBuildException().getMessage());
    }

    public void testFailBadFile()
    {
        runExpecting("testFailBadFile", "is nonexistent file");
        println("BARFAGE:", getBuildException().getMessage());
    }

    public void testFailBadResource()
    {
        runExpecting("testFailBadFile", "is nonexistent resource");
        println("BARFAGE:", getBuildException().getMessage());
    }

    public void testFailBadURL()
    {
        runExpecting("testFailBadFile", "is nonexistent URL");
        println("BARFAGE:", getBuildException().getMessage());
    }

    public void testPassByURL() throws Exception
    {
        verifyLoadable("testByLocalURL","url");
    }

    public void testPassByResource()
    {
        verifyLoadable("testByResource","resource");
    }

    public void testPassByResourceInProperty()
    {
        verifyLoadable("testByBundleInProperty","default-resource");
    }

    public void testPassByResourceWithClassPath()
    {
        verifyLoadable("testByResourceWithClassPath","resource");
    }

    public void testPassByFile_Tmp() throws Exception
    {
        configureTempBuildFileProject(true);
        verifyLoadable(TMP_TARGET,"file");
    }

    public void testPassByFileURL_Tmp() throws Exception
    {
        configureTempBuildFileProject(false);
        verifyLoadable(TMP_TARGET,"file");
    }

    public void testDefaultPassthruYesInherited()
    {
        String log = runTarget("testDefaultPassthruYesInherit");
        verifyOccurances(log,"Helloworld",1);
    }

    public void testDefaultPassthruNoInherited()
    {
        String log = runTarget("testDefaultPassthruNoInherit");
        assertTrue(log.indexOf("Helloworld")>=0, "Output contains 'Helloworld' from msg.0");
        assertTrue(log.indexOf("Byeworld")>=0, "Output contains 'Byeworld' from msg.1");
    }

    public void testDefaultPassthruManyJumpsYesInherited()
    {
        String log = runTarget("testDefaultPassthruManyJumpsYesInherit");
        verifyOccurances(log,"Helloworld",1);
    }

    public void testDefaultPassthruCallOtherAntProcess()
    {
        String log = runTarget("testDefaultPassthruCallOtherAntProcess");
        verifyOccurances(log,"Helloworld",1);
    }

    public void testPassthruStickyLikeVelcro()
    {
        String log = runTarget("testPassthruStickyLikeVelcro");
        verifyOccurances(log,DBG_MSG_UISTRINGS,1);
        assertFalse(log.indexOf(DBG_MSG_OTHER_UISTRINGS)>=0,"Other-UIStrings used as bundle");
    }

    public void testCantLoadBrokenBundleDeclarations()
    {
        verifyCantLoadFile("broken_uism0.xml", "Specified url and resource locations");
        verifyCantLoadFile("broken_uism1.xml", "Specified refid and other locations");
        verifyCantLoadFile("broken_uism2.xml", "Specified refid and nested elements");
    }

    public void testUsingMsgBundleReferences()
    {
        String log = runTarget("testUsingMsgBundleRef");
        verifyOccurances(log,"Byeworld",1);
    }

    public void testUsingMsgBundleReferencesByURL()
    {
        String log = runTarget("testUsingMsgBundleRefByURL");
        verifyOccurances(log,"Byeworld",1);
    }


    public void testNoOpsUnknownManageInstructions()
    {
        String log = runTarget("testUnknownManageDirective");
        String fullLog = getFullLog();
        println("FFFFFFFFUUUUUUUUUULLLLL",fullLog);
        verifyOccurances(log,"Unrecognized operation",1);
    }

    public void testCloningMsgBundlesToChildProject()
    {
        runTarget("testCloningMsgBundlesToChildProject");
    }


    public void testCustomClasspath_AntX04()
    {
        String log = runTarget("testCustomClasspath_AntX04");
        verifyOccurances(log,DBG_MSG_OTHER_UISTRINGS,1);
        assertFalse(log.indexOf(DBG_MSG_UISTRINGS)>=0,"UIStrings used as bundle");
    }

}

/* end-of-InitUISMTaskTest.java */
