/**
 * $Id: FakeIterationConfigurator.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.Iteration;
import  com.idaremedia.antx.starters.IterationConfigurator;
import  com.idaremedia.antx.ut.HTC;

/**
 * Configurator for {@linkplain FakeIteration fake iterations}.
 * <b>Example Usage:</b><pre>
 *    &lt;iterationinit field="privateField" value="boo"/&gt;
 *    &lt;iterationinit field="protectedField" value="blablabla"/&gt;
 * </pre>
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test,helper
 **/

public final class FakeIterationConfigurator extends IterationConfigurator
{
    public static final String INIVALUE = "blank";

    public FakeIterationConfigurator()
    {
        super(AntX.fixture+"FakeIteratorConfigurator:");
    }


    protected Object newInjectionField(Object currentValue) 
    {
        return new String(m_fieldValue);
    }


    public void setField(String fieldName)
    {
        if (fieldName!=null && fieldName.startsWith("inherited:")) {
            fieldName = fieldName.substring("inherited:".length());
        }
        setInjectionFieldName(fieldName);
    }


    public void setValue(String fieldValue)
    {
        m_fieldValue = fieldValue;
    }


    protected void verifyAfterInjection()
    {
        String fieldName = getInjectionFieldName();
        if (FakeIteration.TESTFIELD.equals(fieldName)) {
            String fieldvalue=null;
            try {
                fieldvalue= FakeIteration.inheritedField(fieldName);
            } catch(Exception anyX) {
                HTC.failASAP(anyX);
            }
            HTC.assertEqual(fieldvalue,m_fieldValue,"inheritedField");
        }
        else if (fieldName.startsWith("protected")) {
            HTC.assertEqual(FakeIteration.protectedField(),m_fieldValue,"protectedField");
            HTC.assertNotIdent(FakeIteration.protectedField(),m_fieldValue);
        } else if (fieldName.startsWith("private")) {
            HTC.assertEqual(FakeIteration.privateField(),m_fieldValue,"privateField");
            HTC.assertNotIdent(FakeIteration.privateField(),m_fieldValue);
        }
    }


    protected void verifyInitialFieldState(Iteration context, Object currentValue)
    {
        String fieldname = getInjectionFieldName();
        if (!FakeIteration.TESTFIELD.equals(fieldname)) {
            HTC.assertEqual(currentValue,FakeIteration.INIVALUE,"initialValue of "+fieldname);
        }
    }


    private String m_fieldValue = INIVALUE;
}


/* end-of-FakeIterationConfigurator.java */