/**
 * $Id: FakeIteration.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  com.idaremedia.antx.Iteration;

/**
 * Iteration extension that subclasses Iteration and allows field injection.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test,helper
 **/

public final class FakeIteration extends Iteration 
{
    public static final String INIVALUE= "uninitialized";
    public static final String TESTFIELD = "m_testField";

    public FakeIteration()
    {
        super();
    }
    
    public static final FakeIteration getf()
    {
        return (FakeIteration)get();
    }

    public String getPrivateField()
    {
        return privateField;
    }
    
    public static final String privateField()
    {
        return ((FakeIteration)get()).getPrivateField();
    }
    
    public String getProtectedField()
    {
        return protectedField;
    }
    
    public static final String protectedField()
    {
        return ((FakeIteration)get()).getProtectedField();
    }
    
    public String getInheritedField(String fieldname)
        throws Exception
    {
        if (fieldname.startsWith("inherited:")) {
            fieldname = fieldname.substring("inherited:".length());
        }
        Object value = getFieldValue(fieldname);
        if (value!=null) {
            if (TESTFIELD.equals(fieldname)) {
                return String.valueOf(value);
            }
            return value.getClass().getName();
        }
        return null;
    }
    
    public static final String inheritedField(String fieldname)
        throws Exception
    {
        return getf().getInheritedField(fieldname);
    }


    private String privateField= INIVALUE;
    protected String protectedField= INIVALUE;
    public String publicField= INIVALUE;
}


/* end-of-FakeIteration.java */