/**
 * $Id: ExportTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.solo.ExportTask ExportTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public class ExportTaskTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new ExportTaskTest testcase.
     **/
    public ExportTaskTest(String methodName)
    {
        super("ExportTask::",methodName);
    }


    /**
     * Creates a test suite with a single test.
     **/
    public static TestSuite suiteOfOne(String testName)
    {
        TestSuite s = new TestSuite();
        s.setName("Suite-of-One:"+testName);
        s.addTest(new ExportTaskTest(testName));
        return s;
    }


    /**
     * Create full test suite for ExportTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(ExportTaskTest.class);
    }


    /**
     * Create baseline test suite for ExportTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("export.xml");
    }


// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testFailEmptyElement()
    {
        runExpecting("testFailEmptyElement","Empty Export");
    }

    public void testFailNoName()
    {
        runExpecting("testFailNoName","No Export Variable Name Defined");
    }

    public void testFailNoValue()
    {
        runExpecting("testFailNoValue","No Export Value Defined");
    }

    public void testExportsWithinTask()
    {
        runTarget("testExportsWithinTask");
    }

    public void testExportAcrossProjectInstances()
    {
        runTarget("testExportAcrossProjectInstances");
    }

    public void testLocalExports()
    {
        runTarget("testLocalExports");
    }

    public void testUniversalExport()
    {
        runTarget("testUniversalExport");
    }

    public void testThreadsDontStompOnEachOther()
    {
        runTarget("testThreadsDontStompOnEachOther");
    }

    public void testRemoveVariable()
    {
        runTarget("testRemoveVariable");
    }

    public void testCopyProperty()
    {
        runTarget("testCopyProperty");
    }

    public void testImportProperty()
    {
        runTarget("testImportProperty");
    }

    /** @since JWare/AntX 0.3 **/
    public void testSetFromMultipleSources_AntX03()
    {
        runTarget("testSetFromMultipleSources_AntX03");
    }

    /** @since JWare/AntX 0.3 **/
    public void testBrokenCopyProperty_AntX03()
    {
        runExpecting("testBrokenCopyProperty_AntX03","copyproperty+op");
    }

    /** @since JWare/AntX 0.3 **/
    public void testTimeBasedOperators_AntX03()
    {
        runTarget("testTimeBasedOperators_AntX03");
    }
    
    /** @since JWare/AntX 0.4 **/
    public void testFormTransforms_AntX04()
    {
        runTarget("testFormTransforms_AntX04");
    }

    /** @since JWare/AntX 0.5 **/
    public void testUnassign_AntX05()
    {
        runTarget("testUnassign_AntX05");
    }
    
    /** @since JWare/AntX 0.5 **/
    public void testAllFloats_AntX05()
    {
        runTarget("testAllFloats_AntX05");
    }

    /** @since JWare/AntX 0.5 **/
    public void testStringOps_AntX05()
    {
        runTarget("testStringOps_AntX05");
    }
}


/* end-of-ExportTaskTest.java */
