/**
 * $Id: CPULoader.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.ownhelpers;

import  org.apache.tools.ant.util.ClasspathUtils;

import  com.idaremedia.antx.AntX;

/**
 * Default implementation of a ClassLoader factory method that uses a standard Ant
 * ClasspathUtils Delegate helper.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,infra
 **/

public final class CPULoader implements CustomLoaderFactoryMethod
{
    /**
     * Initializes this adapter for an existing delegate.
     * @param cpud delegate (non-null)
     **/
    public CPULoader(ClasspathUtils.Delegate cpud)
    {
        AntX.require_(cpud!=null,"CPULoader:","ctor- nonzro delegate");
        m_spi= cpud;
    }


    /**
     * Returns the underlying delegate's class loader. Never returns
     * <i>null</i>.
     **/
    public ClassLoader getClassLoader()
    {
        return m_spi.getClassLoader();
    }


    private final ClasspathUtils.Delegate m_spi;
}

/* end-of-CPULoader.java */
