/**
 * $Id: IffValue.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.go;

import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.helpers.Tk;

/**
 * Implementation of the general <em>true</em> and <em>false</em> test for all
 * conditional components. These tests should be set with the <em>resolved</em>
 * value strings.
 *
 * @since    JWare/AntX 0.5
 * @author   ssmc, &copy;2004-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,helper
 * @see      Go
 * @see      Iff
 * @see      Unless
 **/

public final class IffValue
{
    /**
     * Execute test for a simple "if-value-true" conditional parameter.
     * Null property names are not allowed.
     * @since    JWare/AntX 0.5
     * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
     * @version  0.5
     * @.safety  single
     * @.group   impl,helper
     **/
    public static final class IsTrue extends Go.TestSkeleton {
        public IsTrue() {
        }
        public IsTrue(String string) {
            super(string);
        }
        public boolean pass(Project P) {
            verifyInited();
            String test = Tk.resolveString(P,getParameter());
            return Tk.string2PosBool(test)==Boolean.TRUE;
        }
        public String getParameterName() {
            return "ifValueTrue";
        }
    }


    /**
     * Execute test for a simple "if-value-false" conditional
     * parameter. Null property names are not allowed.
     * @since    JWare/AntX 0.5
     * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
     * @version  0.5
     * @.safety  single
     * @.group   impl,helper
     **/
    public static final class IsNotTrue extends Go.TestSkeleton {
        public IsNotTrue() {
        }
        public IsNotTrue(String list) {
            super(list);
        }
        public boolean pass(Project P) {
            verifyInited();
            String test = Tk.resolveString(P,getParameter());
            return Tk.string2NegBool(test)==Boolean.FALSE;
        }
        public String getParameterName() {
            return "ifValueFalse";
        }
    }


    /** Don't allow **/
    private IffValue()
    {
    }
}

/* end-of-IffValue.java */
