/**
 * $Id: SwitchTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.flowcontrol.match.SwitchTask
 * SwitchTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class SwitchTaskTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new SwitchTaskTest testcase.
     **/
    public SwitchTaskTest(String methodName)
    {
        super("SwitchTask::",methodName);
    }


    /**
     * Create full test suite for ProtectedTaskSet.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(SwitchTaskTest.class);
    }


    /**
     * Create baseline test suite for ProtectedTaskSet (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();//new BaselineSuite(SwitchTaskTest.class);
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("switch.xml");
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testNoCasesOK()
    {
        runTarget("testEmptyOK");
    }

    public void testEmptySwitchValueOK()
    {
        runTarget("testEmptySwitchValueOK");
    }

    public void testHaltIfNoMatchByValue()
    {
        runTarget("testHaltIfNoMatchValue");
    }

    public void testHaltIfNoMatchByProperty()
    {
        runTarget("testHaltIfNoMatchProperty");
    }

    public void testNestEqualsFirstForcesOnlyEquals()
    {
        verifyCantLoadFile("broken_switch0.xml", "Mixing 'Equals' and 'Like' choices");
    }

    public void testNestLikeFirstForcesOnlyLikes()
    {
        verifyCantLoadFile("broken_switch1.xml", "Mixing 'Equals' and 'Like' choices");
    }

    public void testEqualsLikeRequireEnclosingMatch()
    {
        configureProjectFromResource("broken_switch2.xml");
        runExpecting("testBrokenXML_LikeEquals_OnlyIn_MatchTask1",
                     "'Equals' and 'Like' require enclosing 'Match'");
        runExpecting("testBrokenXML_LikeEquals_OnlyIn_MatchTask2",
                     "'Equals' and 'Like' require enclosing 'Match'");
    }

    public void testDefaultAlwaysMatches()
    {
        String log = runTarget("testDefaultAlwaysMatches");
        assertTrue(log.indexOf("bingo")>=0,"Found correct match!");
        assertPropertyEquals("the.veggie", "default");
    }

    public void testChoiceByProperties()
    {
        String log= runTarget("testChoiceByProperty");
        assertTrue(log.indexOf("bingo")>=0,"Found correct match!");
    }

    public void testChoiceByAsIsValues()
    {
        String log= runTarget("testChoiceByValue");
        assertTrue(log.indexOf("bingo")>=0,"Found correct match!");
    }

    public void testChoiceByOthers()
    {
        runTarget("testChoiceByOther");
    }

    public void testMatchValueUsed()
    {
        runTarget("testMatchValueUsed");
    }

    public void testLikeCombinations()
    {
        runTarget("testLikeCombinations");
    }

    public void testMultipleMatchesHitsOnlyFirst()
    {
        runTarget("testMultipleMatchesHitsFirst");
    }
    
    public void testChoiceByCondition_AntX05()
    {
        runTarget("testChoiceByCondition_AntX05");
    }
    
    public void testTrueIfElsePresetdefWorks_AntX05()
    {
        runTarget("testTrueIfElsePresetdefWorks_AntX05");
    }
}

/* end-of-SwitchTaskTest.java */
