/**
 * $Id: StopTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.flowcontrol.StopTask
 * StopTask}.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class StopTaskTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new StopTaskTest testcase.
     **/
    public StopTaskTest(String methodName)
    {
        super("StopTask::",methodName);
    }


    /**
     * Create full test suite for StopTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(StopTaskTest.class);
    }


    /**
     * Create baseline test suite for StopTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("stop.xml");
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testEmptyElementOK()
    {
        runTarget("testEmptyElementOK");
    }

    public void testMessageIncluded()
    {
        runTarget("testMessageIncluded");
    }

    public void testMessageArgsIncluded()
    {
        runTarget("testMessageArgsIncluded");
    }

    public void testIfUnlessConditions()
    {
        runTarget("testIfUnlessConditions");
    }

    public void testFatalAbortsAll()
    {
        try { runTarget("testFatalAbortsAll");
        } catch(Throwable bX) {//NB: needed to workaround classloader differences
            String error = bX.getMessage();
            println("*** THROWN: "+bX.getClass().getName());
            println("      What: "+error);
            assertTrue(error.indexOf("fatal build error")>0,"BuildError signalled");
//          //No longer works with Ant 1.6 (ssmc)
//              String clsname = bX.getClass().getName();
//              assertTrue(clsname.indexOf("BuildError")>0, "BuildError caught");
        }
    }

    public void testMsgLevelControlled()
    {
        runTarget("testMsgLevelControlled");
        String debugMsg= "SillyThingToDoWithStop";
        String realLog = getFullLog();
        assertTrue("expecting full log to contain \""+debugMsg+"\" log was \""
                   + realLog + "\"",
                   realLog.indexOf(debugMsg) >= 0);
    }
}

/* end-of-StopTaskTest.java */
